;+
; Project     :	CLUSTER - POLAR - PULSAUR
;
; Name        :	IES_MACHINE
;
; Purpose     :	Sets up machine dependent drawing parameters.
;
; Explanation : Found differences between various machines in drawing widget sizes needed.
;               These are controlled by various parameters returned by this routine.
;
; Use         : < ies_machine, y_adjust, ysizes >
;
; Inputs      : None.
;
; Opt. Inputs : None.
;
; Outputs     : noutputs  : INT no. of panels for display.
;               npoints   : INT no.of points for display.
;               xsize     : INT size of display window
;               wsize     : INT size of scroll window
;               y_adjust  : INT y scroll size adjustment -- to avoid y scroll bars on some machines.
;               y_sizes   : INTARR y sizes of draw windows for different rows in display.
;
; Opt. Outputs:	None.
;
; Keywords    : None.
;
; Calls       :	None.
;
; Common      : None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    : Display.
;
; Prev. Hist. :	None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 16/9/96
;
; Modified    :	Version 0.0, 16/9/96
;                 Original version.
;               Version 0.1, 19/9/96
;                 Change window sizes for IDL 4.0.
;               Version 0.2, 20/8/00
;                 Subsumed set up of xsize, wsize etc into ies_machine,
;                 added extra ysizes for more detectors.
;
; Version     :	Version 0.2, 20/8/00
;-
;**********************************************************

PRO ies_machine, noutputs, npoints, xsize, wsize, y_adjust, ysizes

    ; configuration alpha 3000/600 IDl 3.6.1.c
    ; configuration DEC 5000/133 IDL 3.5.0

    ; y_adjust = 32
    ; ysizes = [ 256, 220, 140, 100, 80 ]

    ; configuration alpha 3000/600 on DEC 5000/133 IDl 3.6.1.c

    ; ysizes = [ 256, 220, 140, 100, 80 ]
    ; y_adjust = 0

    IF !D.NAME EQ 'X' THEN BEGIN

      ; configuration alpha 3000/600 on DEC 5000/133 IDl 4.0.1

      ysizes = [ 256, 220, 140, 90, 60, 60 ]
      y_adjust = 0

      ; x draw view size

      IF noutputs GT 1 THEN xsize = 512 ELSE xsize = 1024

     ; set image scroll size to be 4 pixels per point
      ; or 4 * size of window, whichever is the greater
      ; unless the number of points is too large in which
      ; case set it to one pixel per point

      IF npoints LT 2048 THEN $
        wsize = (4*npoints) > (4*xsize) $
      ELSE $
        wsize = npoints

      ; set maximum size for draw window else Xwindows can reject

      wsize = wsize < 10000

    ENDIF ELSE BEGIN

      ; configuration PC

      ysizes = [ 256, 220, 140, 90, 60, 60 ]
      ;ysizes = [ 512, 440, 280, 180, 120 ] ; ran out of backing store too easily
      y_adjust = 0

      ; scroll does not work properly under windows ensure does not scroll

      ; x draw view size

      IF noutputs GT 1 THEN xsize = 512 ELSE xsize = 1100

      wsize = xsize

    ENDELSE

END

