;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	IES_MAG_BSC
;
; Purpose     :	Creates a magnetic field structure array from .mf tag in IF data.
;
; Use         : < mf = IES_MAG_BSC(header,data) >
;
; Inputs      : header : STRUCTURE IF header info
;               data   : STRUCTURE ARRAY[nsamples] containing data. Has an .mf tag.
;
; Opt. Inputs : None.
;
; Outputs     : mf : STRUCTURE ARRAY[nsamples] giving magnetic field in [azimuth,polar,strength] format in the SC reference frame.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Prev. Hist. :	Adapted from ies add mf for consistency with use of magnetic field generated elsewhere.
;
; Written     :	Version 0.0, Martin Carter, RAL, 31/10/03
;
; Modified    :
;
; Version     :	Version 0.0, 31/10/03
;-
;**********************************************************

FUNCTION ies_mag_bsc, header, data

  ; if no mf tag then cannot create mf

  IF NOT ies_tag_exists(header,'MF') OR NOT ies_tag_exists(data[0],'MF') THEN RETURN, 0

  ; create structure

  IF NOT EXECUTE ( 'structure={' +  header.mf + '_STRUCT_BSC_V0, TIME:0.d0, MF:[0.,0.,0.]}' ) THEN MESSAGE, 'Execute did not work', /TRACEBACK

  mf = REPLICATE(structure,N_ELEMENTS(data))

  mf.time = data.time

  mf.data = data.data

  RETURN, mf

END
