;+
; Project     :	CLUSTER - RAPID, POLAR - CEPPAD
;
; Name        :	IES_MAGNETIC_FIELD_SOURCE
;
; Purpose     :	Determines source of magnetic field info.
;
; Explanation :	Determines source of magnetic field info.
;
; Use         : < src = ies_magnetic_field_source(mf) >
;
; Inputs      : mf : STRUCTURE ARRAY returned by get mf.
;
; Opt. Inputs : None.
;
; Outputs     : src : STRING magnetic field source i.e 'FGM'
;
; Opt. Outputs:	None.
;
; Prev. Hist. :	None..
;
; Written     :	Version 0.0, Martin Carter, RAL, 04/10/03
;
; Modified    :	Version 0.1, 24/10/03
;                 Added possible string input.
;               Version 0.2, 31/10/03
;                 Removed string input.
;                 Changed name from ies magnetic field.
;
; Version     :	Version 0.2, 31/10/03
;-
;**********************************************************

FUNCTION ies_magnetic_field_source, mf

  IF NOT KEYWORD_SET(mf) THEN RETURN, ''

  ; else expect structure array

  str_name = TAG_NAMES(mf[0], /STRUCTURE_NAME)

  ; 'FGM_SC_STRUCT_SC'+sc+'_V0'

  IF STRPOS(str_name,'FGM') GE 0 THEN RETURN, 'FGM'

  ; 'MFE_STRUCT_BSC_V2'

  IF STRPOS(str_name,'MFE') GE 0 THEN RETURN, 'MFE'

  ; 'CMF_STRUCT_BSC_V0'

  IF STRPOS(str_name,'CMF') GE 0 THEN RETURN, 'MF'

  ; 'IEL_STRUCT_BSC_V0'

  IF STRPOS(str_name,'IEL') GE 0 THEN RETURN, 'IEL'

  MESSAGE, 'IMPLEMENTATION ERROR', /TRACEBACK

END
