;+
; Project     :	CLUSTER - POLAR - PULSAUR
;
; Name        :	IES_MIDTIMES
;
; Purpose     :	Gets mid-times of samples
;
; Explanation : Gets mid-times of samples
;
; Use         : < times = ies_midtimes(data) >
;
; Inputs      : data    : structure containing input data
;
; Opt. Inputs : None.
;
; Outputs     : times   : DBLARR{] TAI times
;
; Opt. Outputs:	one.
;
; Keywords    : LIST : LONARR[] list of times for which endtimes required
;
; Written     :	Version 0.0, Martin Carter, RAL, 14/04/03
;                 Derived from ies extdata
;
; Modified    :
;
; Version     :	Version 0.0, 14/04/03
;-
;**********************************************************

FUNCTION ies_midtimes, data

  ; get middle of time samples
  ; dont worry about last point since dummy point

  RETURN, [(data.time+ies_endtimes(data))/2]

END