;+
; Project     :	CLUSTER - PEACE
;
; Name        :	IES_PEDESTAL_PLOT
;
; Purpose     :	Does plot of pedestal information.
;
; Explanation :	Does not assume that data is evenly sampled in time.
;
; Use         : < ies_pedestal_plot,  /WINDOWS, /PS, /PNG, /GIF, /BWPS, TYPE=type, $
;                                     T0=start_time, T1=end_time, FILE=file, /_EXTRA >
;
; Inputs      : None.

; Opt. Inputs : None.
;
; Outputs     : Draws plot on current graphics device.
;
; Opt. Outputs:	None.
;
; Keywords    : /WINDOWS    = plots output in x window.
;               /PS         = plots output as postscript file
;                                if string then assumes it is a file name
;               /PNG        = plots output as PNG file
;                                if string then assumes it is a file name
;               /GIF        = plots output as GIF file
;                                if string then assumes it is a file name
;               /BWPS       = plots output as black and white postscript file
;                                if string then assumes it is a file name
;               T0          = See cep_l1toif.
;               T1          = See cep_l1toif.
;               FILE        = Pedestal data file name.
;               TYPE        = Plot type : 0 = pedestal shift
;                                         1 = centroid
;                                         2 = occupancy
;               /CHECK      = Check if decompressed file already exists before decompressing.
;               /_EXTRA     = Any plot keywords.
;
; Written     :	Version 0.0, Martin Carter, RAL, 11/2/97
;
; Modified    :	Version 0.1, 11/3/97.
;                 Changed pedestal_shift to pedestal_info.
;               Version 0.2 5/6/97
;                 Added ies_gunzip.
;               Version 0.3, MKC, 10/9/97.
;                 Added error return to top level.
;               Version 0.4, MKC, 4/11/97.
;                 Added TYPE keyword.
;               Version 0.5, MKC, 8/4/98.
;                 Added ies_get_dir.
;               Version 0.6, MKC, 9/20/98.
;                 Added ncolors to ies set plot, ies draw luts and ies_draw_pedestal.
;               Version 0.7.
;                    Added -f option to rm.
;               Version 0.8, 13/12/99
;                 Added devname.
;                 Replaced PICKFILE with ies_pickfile.
;               Version 0.9, 8/9/00
;                 Added printout to ps and bwps.
;                 Changed ies set plot call for logo pos.
;               Version 1.0, 10/12/00
;                 Added PNG output
;               Version 1.1, 4/02/02
;                 Used ies_end_plot.
;       	Version 1.2, 11/07/02
;                 Used ies_spawn.
;                 Added CHECK keyword.
;                 Added REMOVE keyword.
;       	Version 1.3, 02/10/03
;                 Changed ies get dir.
;
; Version     :	Version 1.3, 02/10/03
;-
;**********************************************************

PRO ies_pedestal_plot,  WINDOWS=windows, PS=postscript, PNG=png, GIF=gif, BWPS=bwps, NOCT=noct, T0=start_time, T1=end_time, $
                        FILE=file, TYPE=type, CHECK=check, REMOVE=remove, _EXTRA=extra

  ; default plot type

  IF NOT KEYWORD_SET(type) THEN type = 0

  ; get file for pedestals

  IF datatype(file) NE 'STR' THEN file = ies_pickfile ( PATH=ies_get_dir('PD',/POLAR), FILTER='*.PEDESTALS*', $
                                                    /READ, /MUST_EXIST, TITLE='Select PEDESTAL data file' )

  IF file EQ '' THEN MESSAGE, 'NO FILE NAME GIVEN'

  ; set restore variables
  ; NB restore variables are different from normal so cannot use ies_restore_gzip

  time = 0
  luts = 0
  pedestal_info = 0

  ; check if compressed file

  IF ies_test_gzip(file) THEN BEGIN
    ies_gunzip, file, CHECK=check
    gzip = 1
  ENDIF

  ; restore data

  RESTORE, file

  ; remove tmp file

  IF KEYWORD_SET(remove) THEN IF KEYWORD_SET(gzip) THEN IF ies_spawn('rm -f ' + file) THEN MESSAGE, 'REMOVE FAILED'

  ; get data details

  npoints    = (SIZE(pedestal_info))(2)
  nsectors   = (SIZE(pedestal_info))(3)
  ndetectors = (SIZE(pedestal_info))(4)

  ; remove dummy last point

  npoints = npoints - 1

  ; check if any data

  IF npoints EQ 0 THEN RETURN

  time = time(0:npoints-1)

  CASE type OF
    0 : BEGIN
          heading  = ['PEDESTAL SHIFT PLOT for ']
          ytitle = 'Shift [bins]'
          pedestal_data = REFORM(pedestal_info(0,0:npoints-1,*,*),npoints,nsectors,ndetectors)
        END
    1 : BEGIN
          heading  = ['PEDESTAL CENTROID PLOT for ']
          ytitle = 'Centroid position [bins]'
          pedestal_data = REFORM(pedestal_info(1,0:npoints-1,*,*),npoints,nsectors,ndetectors)
        END
    2 : BEGIN
          heading  = ['PEDESTAL OCCUPANCY PLOT for ']
          ytitle = 'Occupancy'
          pedestal_data = REFORM(pedestal_info(2,0:npoints-1,*,*),npoints,nsectors,ndetectors)
        END
    DEFAULT : MESSAGE,'Invalid type'
  ENDCASE

  ies_plot_misc, time, pedestal_data, luts, $
    T0=start_time, T1=end_time, HEADING=heading, YTITLE=ytitle, $
    WINDOWS=windows, PS=postscript, PNG=png, GIF=gif, BWPS=bwps

END
