;+
; Project     :	CLUSTER - RAPID, POLAR - CEPPAD
;
; Name        :	IES_PICKFILE
;
; Purpose     :	Allows selection of filename or names.
;
; Explanation :	Uses PICKFILE as under unix. PC version does not allow wild card character to be returned by filename.
;               This allows multiple file selection as on PCs. Also copes with path not returned with filename.
;
; Use         : < files = ies_pickfile()  >
;
; Inputs      :
;
; Opt. Inputs : None.
;
; Outputs     : files  : STRARR() containing path
;
; Opt. Outputs:	None.
;
; Keywords    : COUNT : INT no of files found
;
; Calls       :	strip_dirname, concat_dir.
;
; Common      : None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    :	Display.
;
; Prev. Hist. :	None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 13/12/99
;
; Modified    :	Version 0,1, MKC, 28/5/00
;                 Added version no check for MULTIPLE_FILES keyword.
;
; Version     :	Version 0.1, 28/5/00
;-
;**********************************************************

FUNCTION ies_pickfile, GET_PATH=path, MULTIPLE_FILES=multiple_files, COUNT=count, _EXTRA=_extra

  count = 0

  ; NB only unrecognized KEYWORDs will be used in DIALOG_PICKFILE

  IF !VERSION.release GT '5.0.3' THEN $
    file = DIALOG_PICKFILE( GET_PATH=path, MULTIPLE_FILES=multiple_files, _EXTRA=_extra) $
  ELSE $
    file = DIALOG_PICKFILE( GET_PATH=path, _EXTRA=_extra)

  ; leave as blank if no file specified
  ; NB file is string array

  IF file[0] EQ '' THEN RETURN, ''

  ; remove directory name from file(s) if present

  file = strip_dirname(file)

  ; add on directory name to file(s)

  file = concat_dir ( path, file)

  count = N_ELEMENTS(file)

  ; check if multiple file names defined at this point ie from WINDOWS

  IF count GT 1 THEN RETURN, file

  ; allow wildcard to get multiple files

  IF STRPOS(file[0],'*') GE 0 THEN file = FINDFILE ( file[0], COUNT=count)

  RETURN, file

END