;+
; Project     :	CLUSTER - RAPID
;
; Name        :	IES_PLOT_ANGLEANGLE
;
; Purpose     :	Plots ANGLEANGLE.
;
; Explanation : Plots ANGLEANGLE.
;
; Use         : < ies_plot_angleangle, xsiz, ysiz, ytop, ncolors, ncolumns, WIDGET=widget >
;
; Inputs      : None.
;
; Opt. Inputs : xsiz : FLOAT
;               ysiz : FLOAT
;               ytop : FLOAT
;               ncolors : INT
;               ncolumns : INT
;
; Outputs     : Displays plots in window.
;
; Opt. Outputs:
;
; Keywords    : WIDGET  : Flag for widget rather than window output.
;
; Prev. Hist. :	Combined IES_PLOT and IES_WINDOW_PLOT versions.
;
; Written     :	Version 0.0, Martin Carter, RAL, 08/05/02
;
; Modified    :	Version 2.8, 09/07/02
;                 Used ies_color_scale routine
;                 Removed WYSIWYG keyword.
;               Version 2.9, 04/02/03
;                 Added MVALS button.
;               Version 3.0, 06/10/03
;                 Added SAMPLE TIME display.
;                 Changed to use ies list samples
;
; Version     :	Version 3.0, 06/10/03
;-
;**********************************************************

PRO ies_plot_angleangle, x_chsize, y_chsize, xsiz, ysiz, ytop, WIDGET=widget

  ; define common blocks used internally for draw widgets
  ; full_header   = structure containing original data header information
  ; full_data     = structure array containing original data
  ; header        = structure containing extracted data header information
  ; data          = structure array containing extracted data
  ; output_info   = structure containing plotting and processing info
  ; output_chans  = array containing processed channel positions
  ; output_array  = array containing processed data for plotting
  ; ids           = structure giving widget IDs
  ; dnfull        = co-ordinate conversion array for full window
  ; dnscroll      = co-ordinate conversion array for magnified windows
  ; files         = STRARR giving data file names
  ; ephem         = structure containing ephemeris data
  ; mf            = structure containing magnetic field data
  ; at            = structure containing attitude data

  COMMON ies_draw_widget_block, full_header, full_data, header, data, output_info, output_chans, output_array, $
                                ids, dnfull, dnscroll, files, ephem, mf, at

  ; get list of good data

  good_list = ies_list_samples(output_info.time,header,data,COUNT=count,NOBAD=output_info.button_values[2])

  IF count GT 0 THEN BEGIN

    ; get sample_no

    sample_no = good_list[0]

    ; set up printout

    time = 'TIME = '+anytim2cal(data[sample_no].time)+' CURSOR = '+anytim2cal(output_info.time)

    IF KEYWORD_SET(widget) THEN BEGIN

      WIDGET_CONTROL, ids.title_ids[0], SET_VALUE=time

    ENDIF ELSE BEGIN

      XYOUTS, 0.5 - STRLEN(time)*x_chsize*1.5/2.0, 1-6*y_chsize, time, CHARSIZE=1.5*!P.CHARSIZE, /NORMAL

    ENDELSE

  ENDIF ELSE BEGIN

    ; if no good data can get here

    time = 'CURSOR = '+anytim2cal(output_info.time)

    IF KEYWORD_SET(widget) THEN WIDGET_CONTROL, ids.title_ids[0], SET_VALUE=time

    RETURN

  ENDELSE

  ; plot data

  vol = output_array(*,*,*,sample_no)

  ; colour scale

  ies_color_scale, output_info, vol

  ; loop through energies plotting data

  FOR k = 0, output_info.ysamples-1 DO BEGIN

    IF KEYWORD_SET(widget) THEN BEGIN

      WIDGET_CONTROL, ids.draw_ids(k+1), GET_VALUE=win
      WSET, win
      ERASE

      ; generate polar/azimuth projection

      ies_plot_img, header, data[sample_no], vol[*,*,k], 2, $
        MASK=output_info.button_values[5], PROJ=output_info.button_values[6], MVALS=output_info.button_values[4]

    ENDIF ELSE BEGIN

      IF k LT 16 THEN BEGIN

        ; set plot region

        !P.REGION = [ 7*x_chsize+(k MOD 4)*xsiz, ytop-ysiz*(k/4+1), 7*x_chsize+(k MOD 4)*xsiz+xsiz, ytop-ysiz*(k/4)]

        ; set parameters for axis labels

        IF (k MOD 4) EQ 0 THEN BEGIN

          IF output_info.button_values[6] THEN ytitle = 'Pitch angle [deg]' ELSE ytitle = 'Polar [deg]'
          ytickformat = ''

        ENDIF ELSE BEGIN

          ytitle = ''
          ytickformat = 'ies_noticks'

        ENDELSE

        IF (k+4) GE output_info.ysamples THEN BEGIN

          xtitle = 'Azimuth [deg]'

          xtickformat = ''

        ENDIF ELSE BEGIN

          xtitle = ''
          xtickformat = 'ies_noticks'

        ENDELSE

        ; set up axes
        ; cheat to avoid last tick name being written

        PLOT, [0,1], XSTYLE=1, YSTYLE=1, XRANGE=[0,359.999], $
                     YRANGE=[0,180], YTICKS=4, YTICKNAME=['180','135','90','45','0'], $
                  /NODATA, TICKLEN=-0.02, /NOERASE, XMARGIN=[0,1],YMARGIN=[0,2.5], $
                  TITLE=band_labels(k), XTITLE=xtitle, YTITLE=ytitle, $
                  XTICKFORMAT=xtickformat, YTICKFORMAT=ytickformat

        ; plot image

        ies_plot_img, header, data[sample_no], vol[*,*,k], !D.FLAGS AND 1, $
               XMARGIN=[0,1], YMARGIN=[0,2.5], $
               MASK=output_info.button_values[5], PROJ=output_info.button_values[6], MVALS=output_info.button_values[4]


        ; replot plot box axes to ensure they are visible

        PLOTS, [!X.WINDOW(0),!X.WINDOW(1),!X.WINDOW(1),!X.WINDOW(0),!X.WINDOW(0)], $
               [!Y.WINDOW(0),!Y.WINDOW(0),!Y.WINDOW(1),!Y.WINDOW(1),!Y.WINDOW(0)], $
               /NORMAL

      ENDIF

    ENDELSE

  ENDFOR

END