
FUNCTION ies_rates, rates, DOPLOT=doplot

  ; assume 2-D array (nplots,nbins)

  s = SIZE(rates)

  nplots = s(1)
  nbins  = s(2)

  ; set up output array

  results = FLTARR(2,nplots)

  ; NB bin 255 has counts from other detectors so must ignore bin 255
  ; only fit to bin 70 for pedestal
 
  maxbin = 70

  ; set up x values

  x = FINDGEN(maxbin+1)

  ; set plot range

  yrange = [MIN(rates(*,0:nplots<254)) > 1, MAX(rates(*,0:nplots<254)>1)]
  xrange = [0,nbins]

  ; loop through all plots

  FOR k = 0, nplots-1 DO BEGIN

    ; fit peak for each plot

    ; with Gaussian plus quadratic

    y = GAUSSFIT ( x, rates(k,0:maxbin), c)

    ; set up results

    results(0,k) = c(1)    
    results(1,k) = SQRT(8.0*ALOG(2.0))*c(2) ; fwhm

    IF KEYWORD_SET(doplot) THEN BEGIN

      ; set plot range

      PLOT_IO, yrange, XRANGE=xrange, /NODATA, XSTYLE=1

      ; plot data 

      oplot, x, rates(k,*), PSYM = 1

      ; plot full fit

      oplot, x, gausscv ( x, c), COLOR=255

      ; plot background

      b = c
      b(0) = 0

      oplot, x, gausscv ( x, b), COLOR=128

      ; plot gaussian

      c(3:5) = 0

      oplot, x, gausscv ( x, c), COLOR=192

      WAIT, 0.2 

    ENDIF

  ENDFOR

  RETURN, results

END

