;**********************************************************
;+
; Project     :	POLAR - CEPPAD
;
; Name        :	IES_REPLACE
;
; Purpose     :	Replaces internal sub-string in string with another substring.
;
; Explanation : Replaces internal sub-string in string with another substring.
;               If pattern a at beginning or end will not replace
;
; Use         : < ostr = ies_replace(istr,a,b) >
;
; Inputs      : istr   : STRING
;               a      : STRING
;               b      : STRING
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 18/04/03
;
; Modified    :
;
; Version     :	Version 0.0, 18/04/03
;-
;**********************************************************

FUNCTION ies_replace, str, a, b

  ; if pattern a at beginning or end will not return null string

  vals = STRSPLIT(str,a,/EXTRACT)

  val = vals[0]

  FOR k = 1, N_ELEMENTS(vals)-1 DO val = val + b +vals[k]

  RETURN, val

END
