;+
; Project     :	CLUSTER - RAPID, POLAR - CEPPAD
;
; Name        :	IES_RESTORE_GZIP
;
; Purpose     :	Restores data file using gzip if necessary. 
;
; Explanation :	Checks if file gzipped then restores and deletes ungzipped file.
;
; Use         : < ies_restore_gzip, filename, input_header, input_data, /CHECK >
;
; Inputs      : filename      : STRING file for compressing.
;
; Opt. Inputs : None.
;
; Outputs     : input_header  : Restored structure.
;               input_data    : Restored structure.
;
; Opt. Outputs:	None.
;
; Keywords    : CHECK  : Flag indicating that should check first if decompressed file already exists.
;               REMOVE : Flag indicating that temporary file should be removed after use.
;
; Calls       :	None.
;                
; Common      :	None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    :	Display.
;
; Prev. Hist. :	None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 27/11/97
;
; Modified    :	Version 0.1.
;                    Added -f option to rm.
;
; Version     :	Version 0.1, 12/1/99
;-
;**********************************************************

PRO ies_restore_gzip, filename, input_header, input_data, CHECK=check, REMOVE=remove

  ; set up variables for data

  input_header = 0
  input_data   = 0

  ; get internal copy of filename

  tmp_file = filename

  ; ungzip file if required

  IF ies_test_gzip(tmp_file ) THEN BEGIN 
      
    ; unzip file, returns temp file name

    ies_gunzip, tmp_file, CHECK=check

    ; get IES data for survey plot

    RESTORE, tmp_file 

    ; remove file

    IF KEYWORD_SET(remove) THEN IF ies_spawn('rm -f ' + tmp_file) THEN MESSAGE, 'REMOVE FAILED'

  ENDIF ELSE BEGIN

    ; get data 

    RESTORE, tmp_file 

  ENDELSE

END
