;+
; Project     :	CLUSTER - RAPID, POLAR - CEPPAD
;
; Name        :	IES_RUNS
;
; Purpose     :	Extends IDL UNIQ function to give list of ends of runs.
;
; Explanation :	IDL UNIQ function is only guaranteed if input array first SORTed
;               If not sorted then do not always get last run reported i.e
;               print,uniq(float([0,0,0,1,1,1,0,0])) --> 2    5
;               print,uniq(float([0,0,0,1,1,1,2,2])) --> 2    5    7
;               I am supposing that other than this UNIQ actually does what is intended.
;
; Use         : < list = ies_runs(array) >
;
; Inputs      : array : ARRAY to be sorted
;
; Opt. Inputs : None.
;
; Outputs     : list  : LONARR list of ends of runs.
;
; Opt. Outputs:	None.
;
; Keywords    : None.
;
; Calls       :	None.
;
; Common      : None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    :	Display.
;
; Prev. Hist. :	None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 20/07/01
;
; Modified    :	None.
;
; Version     :	Version 0.0, 20/07/01
;-
;**********************************************************

FUNCTION ies_runs, array

  ; get list of ends of runs of luts

  list = UNIQ(array)

  ; if list does not include last point then add last point

  IF list[N_ELEMENTS(list)-1] NE N_ELEMENTS(array)-1 THEN list = [list,N_ELEMENTS(array)-1]

  RETURN, list

END
