;+
; Project     :	CLUSTER - RAPID, POLAR - CEPPAD
;
; Name        :	IES_SET_CH_POSITIONS
;
; Purpose     : Sets up ch_positions array from energy channel sizes and energy offset.
;
; Explanation :	Sets up ch_positions array from energy channel sizes and energy offset.
;
; Use         : < ch_positions = ies_set_ch_positions( nenergies, no_of_detectors, no_of_luts, RAPID=rapid) >
;
; Inputs      : nenergies       : INT new no. of energies.
;               no_of_detectors : INT no. of detectors.
;               no_of_luts      : INT no. of LUTS
;
; Opt. Inputs : None.
;
; Outputs     : ch_positions  : INTARR(2,nenergies,no_of_detectors,no_of_luts ) new energy channel positions in bins for each detector and LUT
;
; Opt. Outputs:	None.
;
; Keywords    : RAPID : FLAG indicating rapid data.
;
; Written     :	Version 1.0, Martin Carter, RAL, 17/12/03
;                 Adapted from ies_shift.
;
; Modified    :
;
; Version     :	Version 2.9, 24/10/03
;-
;**********************************************************

FUNCTION ies_set_ch_positions, nenergies, no_of_detectors, no_of_luts, RAPID=rapid

  ; set up new channel boundaries
  ; choose boundaries to remove pedestal contribution from channel 0

  IF NOT KEYWORD_SET(rapid) THEN BEGIN

    ;  new_bin_sizes = [3,6,6,8,11,15,21,30,41,56, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100] ; pre 20/1/97

    new_bin_sizes = [6,6,8,11,15,21,30,41,56, 10, 100, 100, 100, 100, 100, 100, 100, 100, 100]
    new_bin_start = 6

  ENDIF ELSE IF rapid EQ 1 THEN BEGIN

    ; NM

    new_bin_sizes = [5,8,12,14,50,98]
    new_bin_start = 16

  ENDIF ELSE IF rapid EQ 2 THEN BEGIN

    ; BM

    new_bin_sizes = [5,8,12,14,20,30,40,58]
    new_bin_start = 16

  ENDIF ELSE MESSAGE,'IMPLEMENTATION ERROR'

  ch_positions = FLTARR(2, nenergies, no_of_detectors, no_of_luts)

  bin_pos = new_bin_start

  FOR b = 0, nenergies-1 DO BEGIN

    ch_positions[0,b,*,*] = bin_pos

    bin_pos = bin_pos + new_bin_sizes[b]

    ch_positions[1,b,*,*] = bin_pos

  ENDFOR

  RETURN, ch_positions

END
