;+
; Project     :	CLUSTER - RAPID
;
; Name        :	IES_SET_PLOT
;
; Purpose     :	Sets up graphics device for plot.
;
; Explanation : Sets up graphics device for plot.
;               Sets !P.CHARSIZE for plot.
;               Draws RAL logo.
;               Plots box around page.
;               Assumes string for ps or png or gif is file name.
;
; Use         : < result = ies_set_plot ( pageno, devname, unit, file, /LOGO, /WINDOWS, /POSTSCRIPT, /PNG, /GIF, /BWPS, /FULL_ONLY ) >
;
; Inputs      : pageno   : INT page number of plot.
;               devname  : STRING name of main device i.e 'X' or 'WIN'
;
; Opt. Inputs : None.
;
; Outputs     : Returns 0 if successful, 1 if unsuccessful.
;
; Opt. Outputs:	unit   : INT logical unit number for file.
;               file   : STRING file name for output.
;
; Keywords    : /WINDOWS    = plots output in x window.
;               /POSTSCRIPT = plots output as postscript file
;                             Assumes string is file name.
;               /PNG        = plots output as PNG file
;                             Assumes string is file name.
;               /GIF        = plots output as GIF file
;                             Assumes string is file name.
;               /BWPS       = plots output as black and white postscript file
;                             Assumes string is file name.
;               /LOGO       = Position of logo : 1 = top left
;                                                2 = top right
;                                                3 = bottom left
;                                                4 = bottom right
;                                                else no logo
;
;               /FULL_ONLY  = Only full window.
;               /WYSIWYG    = uses display colors only.
;               CHARSIZE    = FLOAT initial value of !P.CHARSIZE
;               LANDSCAPE   = FLAG indicating landscape format
;               PORTRAIT    = FLAG indicating portrait format
;               ENCAPSULATED= FLAG indicating encapsualted postscript format
;               XSIZE       = FLOAT x resolution in pixels or cm (for postscript)
;               YSIZE       = FLOAT y resolution in pixels or cm (for postscript)
;               BACKGROUND  = INT background color
;               FOREGROUND  = FLAG indicating foreground color not used in plot or reported in ies_ncolors..
;               NPLOTS      = INT no. of plot panels
;               /POLAR      = FLAG use POLAR output area
;               /RAPID      = FLAG use RAPID output area
;
; Calls       :	strip_dirname, concat_dir, ies_logo, get_chsize, ies_ncolors.
;
; Common      :	None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    : Display.
;
; Prev. Hist. :	None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 25/10/96
;
; Modified    : 0.1, 28/1/97, MKC.
;                 Added LOGO keyword.
;                 Modified error handling.
;               0.2, 2/5/97
;                 Used full_only tag.
;               0.3, 9/5/97
;                 Removed box around page.
;                 Added full_only keyword.
;               0.4, 9/10/98
;                 Added ncolors to argument list and set up.
;                 Added WYSIWYG keyword.
;               0.5, 14/12/99
;                 Replaced PICKFILE with ies_pickfile.
;               0.6, 8/9/00
;                 Added option of no logo and redefined LOGO keyword.
;               0.7, 7/12/00
;                 Corrected bug in PS output where no logo option not catered for.
;               0.8, 10/12/00
;                 Added PNG output
;               0.9, 15/05/00
;                 Changed png and gif charsize to 1.0 from 0.75. If not fixed then get 2nd panel
;                 titles a dfferent size.
;               1.0, 01/03/02
;                 Increased xoffset for ps plots by 1cm and decreased size by 1 cm to fit on
;                 transparancies.
;               1.1, 09/07/02
;                 Ensured all graphics system variables set to defaults.
;                 Removed ncolors and WYSIWYG from argument lists.
;                 Explicitly set !P.COLOR.
;               1.2, 20/01/03
;                 Removed check to see if graphics file can be opened.
;                 This creates a 0kB file if not overwritten.
;                 If cannot be opened then will see elsewhere.
;               1.3, 03/03/03
;                 Added CHARSIZE keyword to give extra control of text size.
;                 Else text size adjusted automatically.
;                 Ensured set after logo displayed.
;               1.4, 28/03/03
;                 Changed definition of logo positions and default action.
;                 Moved Logo stuff to ies_do_logo.
;                 Used ies_get_file.
;                 Added LANDSCAPE, PORTRAIT, ENCAPSULATED, XSIZE, YSIZE, NPLOTS keywords for compatability
;                 with lsh_device procedure.
;                 Made windows default plot type.
;               1.5, 15/05/03
;                 Added FOREGOUND keyword.
;               1.6. 30/09/03
;                 Added RAPID/POLAR keyword switch.
;                 Renamed ies get file.
;
; Version     :	Version 1.6, 30/09/03
;-
;**********************************************************

FUNCTION ies_set_plot, pageno, devname, unit, file, $
         LOGO=logo, WINDOWS=windows, POSTSCRIPT=postscript, PNG=png, GIF=gif, BWPS=bwps, $
         FULL_ONLY=full_only, CHARSIZE=charsize, LANDSCAPE=landscape, PORTRAIT=portrait, $
         ENCAPSULATED=encapsulated, BACKGROUND=background, FOREGROUND=foreground, $
         XSIZE=xsize, YSIZE=ysize, NPLOTS=nplots, POLAR=polar, RAPID=rapid

  ON_IOERROR, IOERROR

  ;set charsize

  IF NOT KEYWORD_SET(charsize) THEN charsize = 1.0

  ; set graphics variables to defaults

  !P.REGION = [0,0,1,1]
  !P.POSITION = 0
  !P.MULTI = 0
  !P.CHARSIZE = 1

  ; save old file name

  IF N_ELEMENTS(file) NE 0 THEN old_file=file

  ; get file

  file =  ies_get_file_name ( 0, WINDOWS=windows, POSTSCRIPT=postscript, PNG=png, GIF=gif, BWPS=bwps, POLAR=polar, RAPID=rapid)

  IF file EQ '' THEN RETURN, 1

  ; test output device

  IF KEYWORD_SET(postscript) OR KEYWORD_SET(bwps) THEN BEGIN

    IF KEYWORD_SET(postscript) THEN color=1 ELSE color=0

    IF KEYWORD_SET(landscape) THEN BEGIN
      XOFFSET=1.5
      YOFFSET=27.5
      IF KEYWORD_SET(xsize) THEN xsiz = xsize ELSE xsiz=27
      IF KEYWORD_SET(ysize) THEN ysiz = ysize ELSE ysiz=18.9
    ENDIF ELSE BEGIN
      XOFFSET=0.6
      YOFFSET=0.5
      IF KEYWORD_SET(xsize) THEN xsiz = xsize ELSE xsiz=19.9
      IF KEYWORD_SET(ysize) THEN ysiz = ysize ELSE ysiz=26.5
    ENDELSE

    IF KEYWORD_SET(encapsulated) THEN BEGIN

      preview = 2
      pre_xsize = xsiz
      pre_ysize = ysiz

    ENDIF

    IF pageno EQ 0 THEN BEGIN

      SET_PLOT, 'PS'

      DEVICE, COLOR=color, BITS=8, FILE=file, LANDSCAPE=landscape, PORTRAIT=portrait, $
        XOFFSET=xoffset, YOFFSET=yoffset, XSIZE=xsiz, YSIZE=ysiz

      ;DEVICE, COLOR=color, BITS=8, FILE=file, LANDSCAPE=landscape, PORTRAIT=portrait, $
      ;  XOFFSET=xoffset, YOFFSET=yoffset, XSIZE=xsiz, YSIZE=ysiz, $
      ;  ENCAPSULATED=encapsulated, PREVIEW=preview, PRE_XSIZE=pre_xsize, PRE_YSIZE=pre_ysize

     ; change default background selection
     ; NB changed by SET_PLOT
     ; must be set before ERASE

     !P.BACKGROUND = ies_ncolors()-1

     IF KEYWORD_SET(foreground) THEN !P.BACKGROUND = !P.BACKGROUND + 1

     IF N_ELEMENTS(background) NE 0 THEN !P.BACKGROUND = background

    ENDIF ELSE BEGIN

      ERASE

    ENDELSE

    ; fix color table

    ;IF KEYWORD_SET(white) THEN BEGIN

    ;  LOADCT, 41, FILE='/space/carter/sav/colors1.tbl' ; white-rainbow-black
    ;  !P.BACKGROUND = 0
    ;  !P.COLOR = 255

    ;ENDIF ELSE BEGIN

    ;  LOADCT, 39 ; black-rainbow-white
    ;  !P.BACKGROUND = 255
    ;  !P.COLOR = 0

    ;ENDELSE

  ENDIF ELSE BEGIN

    ; set default window size

    xsiz = 600
    ysiz = 800

    ; check nplots keyword

    IF KEYWORD_SET(nplots) THEN BEGIN
      xsiz = 1000
      ysiz = 250*nplots+50
    ENDIF

    ; check full_only keyword

    IF KEYWORD_SET(full_only) THEN BEGIN
      xsiz = 600
      ysiz = 300
    ENDIF

    ; check xsize, ysize keywords

    IF KEYWORD_SET(xsize) THEN xsiz = xsize
    IF KEYWORD_SET(ysize) THEN ysiz = ysize

    IF KEYWORD_SET(png) OR KEYWORD_SET(gif) THEN BEGIN

      IF pageno GT 0 THEN BEGIN

        IF KEYWORD_SET(png) THEN $
          ies_write_png, old_file, TVRD() $
        ELSE $
          ies_write_gif, old_file, TVRD()

        SET_PLOT, devname

      ENDIF

      ; use Z buffer for plots

      SET_PLOT, 'Z'

      DEVICE, SET_RES=[xsiz,ysiz]

    ENDIF ELSE BEGIN

      WINDOW, XSIZE=xsiz, YSIZE=ysiz, /FREE, RETAIN=2

    ENDELSE

    ; change default background selection
    ; NB changed by SET_PLOT
    ; must be set before ERASE

    IF N_ELEMENTS(background) NE 0 THEN !P.BACKGROUND = background

    ; set plot color
    ; NB changed by SET_PLOT

    !P.COLOR = ies_ncolors()-1

    IF KEYWORD_SET(foreground) THEN !P.COLOR = !P.COLOR + 1

    ; clear plot window and set background

    ERASE

  ENDELSE

  ; do logo

  ies_do_logo, LOGO=logo

  ; set charsize (after logo displayed)

  !P.CHARSIZE = charsize

  RETURN, 0

IOERROR:

  SET_PLOT, devname

  IF N_ELEMENTS(ids) GT 0 THEN IF WIDGET_INFO(ids.infoid, /VALID_ID) THEN WIDGET_CONTROL, ids.infoid, SET_VALUE=[STRING(10B),!ERR_STRING], /APPEND

  MESSAGE, !ERR_STRING, /CONT, /TRACEBACK

  RETURN, 1

END
