;+
; Project     :	CLUSTER - PEACE
;
; Name        :	IES_SGAUSSCV
;
; Purpose     :	For use in CURVEFIT. Produces a single Gaussian fit.
;
; Explanation :	For use in CURVEFIT.
;
; Use         : < ies_sgausscv, x, aa, f, fder >
;
; Inputs      : See IDL manual.
;
; Opt. Inputs : None.
;
; Outputs     : See IDL manual.
;
; Opt. Outputs:	None.
;
; Keywords    : None.
;
; Calls       :	None.
;                
; Common      :	None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    :	Display.
;
; Prev. Hist. :	None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 17/1/97
;
; Modified    :	None.
;
; Version     :	Version 0.0, 17/1/97
;-
;**********************************************************

PRO ies_sgausscv, x, aa, f, fder

  ; Fitting function for N Gaussians
  ; expects dimensions of aa to be multiple of three
  ; Used by CURVEFIT i.e
  ;  fit = CURVEFIT ( x, y, wgts, aa, sigs, FUNCTION_NAME = 'sgausscv' )

  ; x = list of npoint x values
  ; a = list of npar   parameter values
  ; fder = (npoints,npar) array of partial derivatives

  ; n gauss curves

  n = N_ELEMENTS(aa)/3

  a = REFORM(aa,3,n)

  ; form partial derivatives

  IF ( N_PARAMS() GT 3 ) THEN fder = DBLARR( N_ELEMENTS(x), N_ELEMENTS(aa) )

  f = 0.0

  FOR k = 0, n-1 DO BEGIN

    IF a(2,k) NE 0.0 THEN z = (x-a(1,k))/a(2,k) ELSE z = 10

    zz = ( z^2 ) < 100

    ez = EXP(-zz/2)

    y  = a(0,k)*ez

    f = f + y

    IF ( N_PARAMS() GT 3 ) THEN BEGIN

      fder(*,k*3)  = ez

      IF a(2,k) NE 0.0 THEN fder(*,k*3+1)  = y*z/a(2,k)

      fder(*,k*3+2)  = fder(*,k*3+1)*z

    ENDIF

  ENDFOR

END
