;+
; Project     :	CLUSTER - RAPID, POLAR - CEPPAD
;
; Name        :	IES_SPAWN
;
; Purpose     :	Provides a wrapper around any SPAWN process used. 
;
; Explanation :	Provides a wrapper around any SPAWN process used.  
;
; Use         : < err = ies_spawn(command) >
;
; Inputs      : command : STRING command
;
; Opt. Inputs : None.
;
; Outputs     : err : 1 if error, 0 if ok.
;
; Opt. Outputs:	None.
;
; Keywords    : None.
;
; Calls       :	None.
;                
; Common      : None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    :	Display.
;
; Prev. Hist. :	None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 11/07/02
;
; Modified    :	
;
; Version     :	Version 0.0, 11/07/02
;-
;**********************************************************

FUNCTION ies_spawn, command

  SPAWN, command, res, err

  IF KEYWORD_SET(err) THEN BEGIN

    FOR k = 0, N_ELEMENTS(err)-1 DO MESSAGE, err[k], /INFORMATIONAL

    RETURN, 1

  ENDIF ELSE IF KEYWORD_SET(res) THEN BEGIN

    FOR k = 0, N_ELEMENTS(res)-1 DO PRINT, res[k]

    RETURN, 0
  
  ENDIF 

  RETURN, 0

END
