;+
; Project     :	POLAR - CEPPAD
;
; Name        :	ies_sum
;
; Purpose     :	Sums over sectors, detectors, energies.
;
; Explanation : Sums over sectors, detectors, energies.
;
; Use         : < array = ies_sum( header, data ) >
;
; Inputs      : header : STRUCTURE conntaining header info.
;               data   : STRUCTURE ARRAY containing data.
;
; Opt. Inputs : None.
;
; Outputs     : array : FLTARR(nsamples) omnidirectional flux or counts.
;
; Opt. Outputs:	None.
;
; Keywords    : CAL   : FLAG indicating should apply geometric calibration factor.
;               RAT   : FLAG indicating should apply counts per second.
;               E0    : INT low energy channel
;               E1    : INT high energy channel.
;               NOBAD : FLAG indicating should not use any data flagged as bad.
;
; Written     :	Version 0.0, Martin Carter, RAL, 13/03/02
;
; Modified    : 0.1, 20/11/03
;                 Used routine ies do cal instead of ies docal.
;
; Version     :	Version 0.1, 20/11/03
;-
;**********************************************************

FUNCTION ies_sum, header, data, CAL=cal, RAT=rat, E0=e0, E1=e1, NOBAD=nobad

  output_info = {cal:0, div:0, rat:0}

  IF KEYWORD_SET(cal) THEN output_info.cal = 1

  IF KEYWORD_SET(rat) THEN output_info.rat = 1

  ; calibrate data
  ; NB cannot use shift or subtract

  ies_do_cal, ies_lut_list(data.lut, header.nluts ), header, data, output_array, output_chans, nbands, output_info

  ; spin average
  ; NB applied to output_array not data

  output_array = ies_average ( output_array, output_info, header, data, /SPIN_AVERAGE)

  output_array = REFORM (output_array, 1, header.ndetectors, nbands, header.npoints)

  ; detector average
  ; NB applied to output_array not data

  output_array = ies_average ( output_array, output_info, header, data, /DETECTOR_AVERAGE)

  output_array = REFORM (output_array, 1, 1, nbands, header.npoints)

  ; energy average
  ; does not deal convincingly with energy efficiencies yet

  output_array = TOTAL(output_array[0,0,e0:e1,*], 3)

  output_array = REFORM ([output_array], header.npoints)

  RETURN, output_array

END
