;+
; Project     :	CLUSTER - PEACE
;
; Name        :	IES_SUN_OFFSETS
;
; Purpose     :	Get sun sector offsets.
;
; Explanation :	Get sun sector offsets.
;
; Use         : <  >
;
; Inputs      :
;
; Opt. Inputs : mple.
;
; Outputs     :
;
; Opt. Outputs:	None.
;
; Keywords    : None.
;
; Calls       :	None.
;
; Common      :	None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    :	Display.
;
; Prev. Hist. :	None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 31/01/03
;                 Adapted from ies extdata.
;
; Modified    :	Version 0.1, 29/09/03
;                 Used new routine for instrument test.
;
; Version     :	Version 0.1, 29/09/03
;-
;**********************************************************

FUNCTION ies_sun_offsets, datatype, times

  ; determine whether RAPID, POLAR or OTHER

  IF ies_instrument(datatype,/RAPID) THEN BEGIN

    ; RAPID

    offsets = rcs_sun_offsets(STRMID(datatype,6,1),times)

  ENDIF ELSE IF ies_instrument(datatype,/POLAR) THEN BEGIN

    ; CEPPAD

    IF ies_instrument(datatype,/IPS)  THEN offsets = REPLICATE( 7.625*!PI/180, N_ELEMENTS(times)) ELSE $
    IF ies_instrument(datatype,/IES)  THEN offsets = REPLICATE(-3.375*!PI/64, N_ELEMENTS(times)) ELSE $
    IF ies_instrument(datatype,/HIST) THEN offsets = REPLICATE(-3.375*!PI/64, N_ELEMENTS(times)) ELSE $
                                                    offsets = REPLICATE(0.0, N_ELEMENTS(times))

    ; adjust for changes made to offset

    list = WHERE(times LT utc2tai(anytim2utc('06/06/96 19:36:00')), count)

    IF offsets[0] NE 0.0 AND count GT 0 THEN offsets[list] = offsets[list] - 5*!PI/180.

  ENDIF

  RETURN, offsets

END
