;+
; Project     :	CLUSTER - RAPID, POLAR - CEPPAD
;
; Name        :	IES_TAG_EXISTS
;
; Purpose     :	Tests if tag exists in structure. 
;
; Explanation :	Tests if tag exists in structure. 
;
; Use         : < res = ies_tag_exists(str,tag) >
;
; Inputs      : str      : STRUCTURE structure.
;               tag      : STRING tag name
;
; Opt. Inputs : None.
;
; Outputs     : res : FLAG 0 : tag does not exist
;                          1 : tag exists.
;
; Opt. Outputs:	None.
;
; Keywords    : None.
;
; Calls       :	None.
;                
; Common      : None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    :	Utility.
;
; Prev. Hist. :	None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 12/07/02
;
; Modified    :	None.
;
; Version     :	Version 0.0, 12/07/02
;-
;**********************************************************

FUNCTION ies_tag_exists, str, tag

  IF (WHERE(TAG_NAMES(str) EQ tag))[0] GE 0 THEN RETURN,1 ELSE RETURN,0

END
