;+
; Project     :	CLUSTER - RAPID, POLAR - CEPPAD
;
; Name        :	IES_TEST_GZIP
;
; Purpose     :	Tests whether data file is GZIPed. 
;
; Explanation :	Looks at file name to see if compressed file.
;               Expects file extension .gz or .Z 
;
; Use         : < res = ies_test_gzip ( filename ) >
;
; Inputs      : filename      : STRING file name for test.
;
; Opt. Inputs : None.
;
; Outputs     : res      : Logical flag indictaing whether file is compressed file.
;
; Opt. Outputs:	None.
;
; Keywords    : None.
;
; Calls       :	None.
;                
; Common      : None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    :	Display.
;
; Prev. Hist. :	None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 1/8/97
;
; Modified    :	Version 0.1, MKC, 28/8/97
;                 Added extension .Z
;
; Version     :	Version 0.1, 28/8/97
;-
;**********************************************************

FUNCTION ies_test_gzip, filename

  IF STRPOS(filename,'.gz') GE 0 OR STRPOS(filename,'.Z') GE 0 THEN RETURN, 1 ELSE RETURN, 0

END
