;+
; Project     :	CLUSTER - RAPID, POLAR - CEPPAD
;
; Name        :	IES_TIME
;
; Purpose     :	Returns current time.
;
; Explanation :	Returns current time.
;
; Use         : < time = ies_time() >
;
; Inputs      : None.
;
; Opt. Inputs : None.
;
; Outputs     : time : STRING current time
;                      DOUBLE if TAI set.
;
; Opt. Outputs:	None.
;
; Keywords    : FORM : keyword accepted by anytim2cal.
;               TAI  : FLAG indicating want TAI output.
;
; Calls       :	None.
;
; Common      : None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    :	Display.
;
; Prev. Hist. :	None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 20/07/01
;
; Modified    :	Version 0.1, 04/12/03
;                 Added TAI keyword.
;
; Version     :	Version 0.1, 04/12/03
;-
;**********************************************************

FUNCTION ies_time, FORM=form, TAI=tai

  get_utc, utc

  IF KEYWORD_SET(tai) THEN $
    RETURN, anytim2tai(utc) $
  ELSE $
    RETURN, anytim2cal(utc, FORM=form)

END
