;+
; Project     :	POLAR - CEPPAD
;
; Name        :	IES_WRITE_GIF
;
; Purpose     :	Writes GIF file.
;
; Explanation :	May check IDL version number.
;
; Use         : < ies_write_gif, filename, image >
;
; Inputs      : filename : STRING name of file.
;               image    : BYTARR image data
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs:	None.
;
; Keywords    : None.
;
; Calls       :	None.
;
; Common      :	None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    :	Display.
;
; Prev. Hist. :	None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 13/12/00
;
; Modified    :
;
; Version     :	Version 0.0, 13/12/00
;-
;**********************************************************

PRO ies_write_gif, filename, image

  IF !VERSION.release LT '5.4' THEN BEGIN

    write_gif, filename, image

  ENDIF ELSE BEGIN

    PRINT, 'WARNING, GIF OUTPUT NOT AVAILABLE : '+filename

  ENDELSE

END
