;
 PRO eph_polar_spec_ax, sut, xf, mode, tlims

; sut : sample times in decimal hours
; xf  : sample values
; mode : data type
;   mode = 0 :   ALT data     (Orbital Altitude in Earth Radii)
;   mode = 1 :   MLAT data    (Magnetic Latitude in degrees)
;   mode = 2 :   LSHELL data  (Magnetic L-Shell)
;   mode = 3 :   MLT data     (Magnetic Local Time in UT Hours)
; tlims : plot window time limits in decimal hours
;

 sut0 = sut
 xf0 = xf
 max_sut = MAX(sut)
 min_sut = MIN(sut)

 np = n_elements ( sut )

 IF np LT 9 THEN RETURN     ; MKC

 dxt = sut ( 5 )

 dut = ( max_sut  - min_sut )

 nsamp = 7500
 if ( dut gt 18.0 ) then nsamp = 10000
 
 ; get time range (MKC)

 tmin = MAX([tlims(0),min_sut])
 tmax = MIN([tlims(1),max_sut])

 ; fut is new sample itmes 

 fut = tmin + ( findgen ( nsamp+1 ) * ( tmax - tmin ) /  $
                       float ( nsamp ) )

 if ( mode eq 2 ) then begin
     lxf = alog10 ( xf )
     sxf = spline ( sut, lxf, fut )
     sxf = 10.0 ^ sxf
 endif else begin
     sxf = spline ( sut, xf, fut )
 endelse

 dtlims = tlims ( 1 ) - tlims ( 0 )

 dmaj_x0 = 1.0
 dmin_x0 = 0.2
 if ( dtlims lt 10.0 ) then dmin_x0 = 0.1

 xthres0 = 0.004175

 if ( dtlims lt 23.50 ) then begin

     wz1 = where ( sut ge tlims ( 0 ) )
     wz2 = where ( sut gt tlims ( 1 ) )

     if ( wz1 ( 0 ) eq -1 ) then wz1 = [ 0, 0 ]
     if ( wz2 ( 0 ) eq -1 ) then wz2 = [ np, np ]

     sut = sut ( wz1 ( 0 ) : wz2 ( 0 ) - 1 )
     xf = xf ( wz1 ( 0 ) : wz2 ( 0 ) - 1 )

     dxt = ( max ( sut ) - min ( sut ) ) / 100.0

 endif

 if ( !d.x_size gt !d.y_size ) then dxt = dxt / 2.0

 np = n_elements ( sut )

 IF np LT 9 THEN RETURN     ; MKC

 mmin = min ( xf )
 mmax = max ( xf )

 mrng = mmax - mmin

 imarg = 125
 if ( dtlims lt 10.0 ) then imarg = 200
 if ( dtlims lt 6.0 ) then imarg = 250
 if ( dtlims lt 2.5 ) then imarg = 325

 itxt = 1

 if ( mrng lt 4.0 ) then dmaj_x0 = 0.5

 if ( mrng lt 2.0 ) then begin
     dmaj_x0 = 0.25
     dmin_x0 = 0.05
     itxt = 2
     imarg = 500
 endif

 if ( mrng lt 1.0 ) then begin
     dmaj_x0 = 0.1
     dmin_x0 = 0.01
     itxt = 1
     imarg = 250
     xthres0 = 0.00375
 endif

 if ( mrng lt 0.5 ) then begin
     dmaj_x0 = 0.1
     dmin_x0 = 0.01
     itxt = 1
     imarg = 400
     xthres0 = 0.00375
 endif

 tick_sz = 0.2*(!Y.CRANGE(1) - !Y.CRANGE(0)) ; fractions of plot window size

 xwf0 = -0.5

 xwthres = 0.02875

 iwrite = -99

 ixmin0 = 1.0

 xcut = 4.50

 if ( mode eq 1 ) then  xcut = 0.0

 if ( mode eq 1 ) then begin
     dmaj_x0 = 10.0
     dmin_x0 = 2.0
     xthres0 = 0.00675
     xwthres = 0.04375

     mmin = min ( xf )
     mmax = max ( xf )

     mrng = mmax - mmin

     if ( mrng lt 40.0 ) then dmaj_x0 = 5.0
     if ( mrng lt 40.0 ) then dmin_x0 = 1.0

     if ( dtlims lt 10.0 ) then dmin_x0 = 1.0
 endif

 if ( mode eq 2 ) then begin
     dmaj_x0 = 5.0
     dmin_x0 = 1.0
     xthres0 = 0.00675
     xwthres = 0.0375

     if ( dtlims lt 10.0 ) then xthres0 = 0.00375
     if ( dtlims lt 5.0 ) then xthres0 = 0.00175
     if ( dtlims lt 10.0 ) then dmaj_x0 = 1.0
     if ( dtlims lt 10.0 ) then dmin_x0 = 0.2
 endif

 xvl = -99.0
 xvl0 = 0.0

 imarg0 = imarg

 if ( !d.x_size gt !d.y_size ) then xwthres = xwthres / 1.475

 ; loop over new samples, plot tick marks and tick labels

 for i = 5, nsamp - 5 do begin

     if ( ( mode eq 2 ) and ( sxf ( i ) gt 30.875 ) ) then goto, fcont

     if ( ( mode eq 3 ) and ( i lt 6775 ) ) then begin

         ii = 5 + 750 * ( ( i - 5 ) / 750 )

         if ( ii eq i ) then begin
             dmaj_x0 = 4.0
             dmin_x0 = 1.0
             xthres0 = 0.00875
             xwthres = 0.0575

             if ( dtlims lt 15.0 ) then xthres0 = 0.00475
             if ( dtlims lt 10.0 ) then xthres0 = 0.00375
             if ( dtlims lt 5.0 ) then xthres0 = 0.0025
             if ( dtlims lt 10.0 ) then dmaj_x0 = 1.0
             if ( dtlims lt 10.0 ) then dmin_x0 = 0.166667
             if ( dtlims lt 5.0 ) then dmaj_x0 = 0.5
             if ( dtlims lt 5.0 ) then dmin_x0 = 1.0 / 12.0

             nf = 1250
             if ( i gt 6500 ) then nf = 675

             mmin = min ( sxf ( i:i+nf ) )
             mmax = max ( sxf ( i:i+nf ) )

             mrng = mmax - mmin

             if ( mrng lt 8.0 ) then dmaj_x0 = 2.0
             if ( mrng lt 8.0 ) then dmin_x0 = 0.25
             if ( mrng lt 4.0 ) then dmaj_x0 = 1.0
             if ( mrng lt 4.0 ) then dmin_x0 = 1.0 / 12.0
             if ( mrng lt 2.0 ) then dmaj_x0 = 0.5
             if ( mrng lt 2.0 ) then dmin_x0 = 1.0 / 15.0
             if ( mrng lt 1.0 ) then dmaj_x0 = 0.1666667
             if ( mrng lt 1.0 ) then dmin_x0 = 1.0 / 60.0
             if ( mrng lt 0.5 ) then dmaj_x0 = 1.0 / 12.0
             if ( mrng lt 0.5 ) then dmin_x0 = 1.0 / 60.0
         endif
     endif

     dmaj_x = dmaj_x0
     dmin_x = dmin_x0
     xthres = xthres0

     if ( ( mode eq 0 ) and ( sxf ( i ) gt 8.875 ) ) then imarg = 750       $
     else imarg = imarg0

     if ( ( mode eq 1 ) and ( sxf ( i ) lt 0.0 ) ) then begin
         dmaj_x = 30.0
         dmin_x = 10.0
         if ( dtlims lt 10.0 ) then dmaj_x = 10.0
         if ( dtlims lt 10.0 ) then dmin_x = 2.5
         xthres = 0.00875
     endif

     if ( ( mode eq 2 ) and ( sxf ( i ) gt 10.0 ) ) then begin
         dmaj_x = 10.0
         dmin_x = 1.0
         xthres = 1.375 * xthres0
     endif

     if ( mode eq 2 ) then begin
         lgrad = abs ( sxf ( i + 5 ) - sxf ( i - 5 ) )
         if ( lgrad gt 0.25 ) then xthres = xthres * 2.0
     endif

     xmaj = abs ( ( sxf ( i ) / dmaj_x ) )
     xmin = abs ( ( sxf ( i ) / dmin_x ) )

     ixmaj = abs ( xmaj - fix ( xmaj + 0.125 ) )

     ixmin = abs ( xmin - fix ( xmin + 0.05 ) )

     if ( ixmin le 8.750 * xthres ) then begin

         xx = [ fut ( i ), fut ( i ) ]

         tfac = 1.0

         if ( ixmaj lt 5.0 * xthres ) then tfac = 1.66667

         yy = [ 0.0, tfac * tick_sz ]

         xvl = dmin_x * fix ( abs ( sxf ( i ) / dmin_x ) + 0.125 )

         if ( sxf ( i ) lt 0.0 ) then xvl = -1.0 * xvl

         if ( xvl eq xvl0 ) then goto, fcont

         iwrite = i

         oplot, xx, yy

         if ( tfac gt 1.0 ) then begin

             xwf = ( fut ( i ) - tlims ( 0 ) ) / ( tlims ( 1 ) - tlims ( 0 ) )

             if ( ( xwf - xwf0 ) gt xwthres ) then begin

                 xvl = dmaj_x * fix ( ( sxf ( i ) / dmaj_x ) + 0.125 )

                 xtxt = string ( format = '( f4.1 )', xvl )
                 if ( itxt eq 2 ) then xtxt = string ( format = '( f4.2 )', xvl )

                 if ( mode eq 1 ) then begin
                      xvl = dmin_x * fix ( abs ( sxf ( i ) / dmin_x ) + 0.125 )
                      if ( sxf ( i ) lt 0.0 ) then xvl = -1.0 * xvl
                      xtxt = strcompress ( string ( format = '( i3 )', xvl ),  $
                                           /remove_all )
                 endif

                 if ( mode eq 2 ) then begin
                      xvl = dmaj_x * fix ( ( sxf ( i ) / dmaj_x ) + 0.125 )
                      xtxt = string ( format = '( f5.1 )', xvl )
                 endif

                 if ( mode eq 3 ) then begin
                      xvl = dmaj_x * fix ( ( sxf ( i ) / dmaj_x ) + 0.125 )
                      if ( xvl ge 24.0 ) then xvl = xvl - 24.0 * ( fix ( xvl / 24.0 ) )

                      hr = fix ( xvl )
                      mn = fix ( 60.0 * ( xvl - hr ) + 0.5 )
                      xtxt = STRING ( FORMAT = '( 2(I2.2,A) )', hr, ':',mn, ' ' )

                 endif

                 oplot, xx, yy*1.5

                 xyouts, fut ( i ), -0.9, xtxt, alignment = 0.5, size = 0.7*!P.CHARSIZE

                 xwf0 = xwf

             endif 

         endif

     endif

     xvl0 = xvl

 fcont:

     if ( ( i - iwrite ) gt imarg ) then xvl0 = -99.0

 endfor

 ; do any special characters 

 xmin = min ( xf )

 wz = where ( xf lt 1.0475 * xmin )

 if ( mode eq 1 ) then wz = where ( xf lt ( xmin + 17.5 ) )

 if ( mode eq 2 ) then begin
     dlsh = xf ( 1:np-1 ) - xf ( 0:np-2 )

     ddlsh = dlsh ( 1:np-2 ) - dlsh ( 0:np-3 )

     wz = where ( abs ( dlsh ) lt 0.05 )
     wz = wz + 1

     nwz = n_elements ( wz )

     dwz = 0
     nmin = 1

     if ( nwz gt 2 ) then dwz = wz ( 1:nwz-1 ) - wz ( 0:nwz-2 )

     goto, lcont

 endif

 if ( mode eq 3 ) then wz = where ( xf lt 1.00475 * xmin )

 nwz = n_elements ( wz )

 if ( ( wz ( 0 ) eq -1 ) or ( nwz eq 1 ) ) then goto, econt

 dwz = wz ( 1:nwz-1 ) - wz ( 0:nwz-2 )

 nmin = 1

 dmx = max ( dwz )

 nc1 = !c

 if ( dmx gt 1.5 ) then nmin = 2

 if ( nmin eq 1 ) then nc1 = nwz

 dxf = [ 0.05, 0.0 ]

 if ( nc1 gt 2 ) then  dxf = xf ( wz ( 1:nc1-1 ) ) - xf ( wz ( 0:nc1-2 ) )

 dxt1 = total ( dxf * dxf )

 nz = where ( dxf ne 0.0 )
 
 dxf2 = [ 0.0, 0.0 ]

 if ( nz ( 0 ) ne -1 ) then                                                  $
    dxf2 = ( abs ( dxf ( nz ) ) / dxf ( nz ) ) * ( dxf ( nz ) * dxf ( nz ) )

 dxt2 = total ( dxf2 )

 if ( dxt1 eq abs ( dxt2 ) ) then goto, econt

;;; if ( ( dxt1 le 0.00175 ) or ( abs ( dxt2 ) le 0.00175 ) ) then goto, econt

 if ( nmin eq 1 ) then ic = fix ( total ( wz ) / float ( nwz ) )

lcont:

 if ( mode eq 2 ) then begin

     if ( nwz eq 1 ) then dwz = 0.

     wmx = where ( dwz gt 1.5 )

     nmin = n_elements ( wmx )

     if ( wmx ( 0 ) ne -1 ) then nmin = nmin + 1

     yy = [ 0., 1.50 * tick_sz, 1.50 * tick_sz, 3.50 * tick_sz,              $
            1.50 * tick_sz,  3.50 * tick_sz ]

     nc0 = 0

     for j = 0, nmin-1 do begin

         if ( j lt nmin-1 ) then nc1 = wmx ( j )
         if ( j eq nmin-1 ) then nc1 = n_elements ( wz ) - 1
         if ( nmin eq 1 ) then nc1 = n_elements ( wz ) - 1

         xmn = min ( xf ( wz ( nc0:nc1 ) ) )

         wz2 = where ( xf ( wz ( nc0:nc1 ) ) lt 1.0375 * xmn )

         np2 = n_elements ( wz2 )

         ic = fix ( total ( wz ( nc0+wz2 ) ) / float ( np2 ) )

         if ( ( ic le 1 ) or ( ic ge np-2 ) ) then goto, xrng

         if ( xf ( ic ) gt 30.0 ) then goto, xrng

         xx = [ sut ( ic ), sut ( ic ), sut ( ic ), sut ( ic ) - dxt,        $
                sut ( ic ), sut ( ic ) + dxt ]

         oplot, xx, yy

 xrng:
         nc0 = nc1 + 1

         if ( nmin eq 1 ) then goto, econt

     endfor

     goto, econt

 endif

 if ( nmin eq 2 ) then ic = fix ( total ( wz (0:nc1 ) ) / float ( nc1+1 ) )

 if ( ( ic lt 3 ) or ( ic gt np-4 ) ) then goto, econt

 if ( ( mode eq 0 ) and ( xf ( ic ) gt 5.0 ) ) then goto, econt 
 if ( ( mode eq 1 ) and ( xf ( ic ) gt 5.0 ) ) then goto, econt 
 if ( ( mode eq 2 ) and ( xf ( ic ) gt 5.0 ) ) then goto, econt 

 xx = [ sut ( ic ), sut ( ic ), sut ( ic ), sut ( ic ) - dxt, sut ( ic ),    $
        sut ( ic ) + dxt ]
 yy = [ 0., 1.50 * tick_sz, 1.50 * tick_sz, 3.50 * tick_sz,                  $
        1.50 * tick_sz,  3.50 * tick_sz ]

 oplot, xx, yy

 if ( nmin eq 2 ) then begin
     ic = fix ( total ( wz ( nc1+1:nwz-1 ) ) / float ( nwz-nc1-1 ) )

     xx = [ sut ( ic ), sut ( ic ), sut ( ic ), sut ( ic ) - dxt,            $
            sut ( ic ), sut ( ic ) + dxt ]

     oplot, xx, yy

 endif

 econt:

 xmx = max ( xf )

 wz = where ( xf gt ( 0.9925 * xmx ) )

 if ( ( mode eq 0 ) and ( xmx lt 7.5 ) ) then goto, eplt

 if ( mode eq 1 ) then wz = where ( xf gt 72.50 )
 if ( ( mode eq 1 ) and ( wz ( 0 ) eq -1 ) ) then wz = where ( xf gt 67.50 )

 if ( mode eq 2 ) then begin

     wz = where ( ddlsh lt -0.0075 )
     wz = wz + 1

     nwz = n_elements ( wz )

     dwz = 0
     nmax = 1

     if ( nwz gt 2 ) then dwz = wz ( 1:nwz-1 ) - wz ( 0:nwz-2 )

     goto, hcont

 endif

 if ( mode eq 3 ) then begin
     xmx = max ( xf )
     wz = where ( xf gt 0.99875 * xmx )
     if ( xmx gt 24.0 ) then wz = where ( xf gt 0.999675 * xmx )
 endif

 if ( wz ( 0 ) eq -1 ) then goto, eplt

 nmax = 1

 nwz = n_elements ( wz )

 if ( nwz eq 1 ) then goto, hcont

 dwz = wz ( 1:nwz-1 ) - wz ( 0:nwz-2 )

 dmx = max ( dwz )

 nc1 = !c

 if ( dmx gt 1.5 ) then nmax = 2

 if ( nmax eq 1 ) then nc1 = nwz

; if ( nc1 eq 0 ) then goto, eplt
 if ( nc1 le 1 ) then goto, eplt ; MKC

 dxf = xf ( wz ( 1:nc1-1 ) ) - xf ( wz ( 0:nc1-2 ) )

 dxt1 = total ( dxf * dxf )
 
 nz = where ( dxf ne 0.0 )
 
 dxf2 = [ 0.0, 0.0 ]

 if ( nz ( 0 ) ne -1 ) then                                                  $
    dxf2 = ( abs ( dxf ( nz ) ) / dxf ( nz ) ) * ( dxf ( nz ) * dxf ( nz ) )

 dxt2 = total ( dxf2 )

 if ( dxt1 eq abs ( dxt2 ) ) then goto, eplt

;;; if ( ( dxt1 le 0.00175 ) or ( abs ( dxt2 ) le 0.00175 ) ) then goto, eplt

 hcont:

 if ( nmax eq 1 ) then ic = fix ( total ( wz ) / float ( nwz ) )

 if ( mode eq 2 ) then begin

     if ( nwz eq 1 ) then dwz = 0.

     wmx = where ( dwz gt 1.5 )

     nmax = n_elements ( wmx )

     if ( wmx ( 0 ) ne -1 ) then nmax = nmax + 1

     yy = [ 0., 3.50 * tick_sz, 3.50 * tick_sz, 1.50 * tick_sz,              $
            3.50 * tick_sz,  1.50 * tick_sz ]

     nc0 = 0

     for j = 0, nmax-1 do begin

         if ( j lt nmax-1 ) then nc1 = wmx ( j )
         if ( j eq nmax-1 ) then nc1 = n_elements ( wz ) - 1
         if ( nmax eq 1 ) then nc1 = n_elements ( wz ) - 1
         ic = fix ( total ( wz (nc0:nc1 ) ) / float ( nc1-nc0+1 ) )

         if ( ( ic le 1 ) or ( ic ge np-2 ) ) then goto, orng

         xx = [ sut ( ic ), sut ( ic ), sut ( ic ), sut ( ic ) - dxt,        $
                sut ( ic ), sut ( ic ) + dxt ]

         oplot, xx, yy

         nc0 = nc1 + 1

 orng:

         if ( nmax eq 1 ) then goto, eplt

     endfor

     goto, eplt
 endif

 if ( nmax eq 2 ) then ic = fix ( total ( wz (0:nc1 ) ) / float ( nc1+1 ) )

 if ( ( ic lt 3 ) or ( ic gt np-4 ) ) then goto, eplt

 xx = [ sut ( ic ), sut ( ic ), sut ( ic ), sut ( ic ) - dxt, sut ( ic ),    $
        sut ( ic ) + dxt ]
 yy = [ 0., 3.50 * tick_sz, 3.50 * tick_sz, 1.50 * tick_sz, 3.50 * tick_sz,  $
            1.50 * tick_sz ]

 oplot, xx, yy

 if ( nmax eq 2 ) then begin
     ic = fix ( total ( wz ( nc1+1:nwz-1 ) ) / float ( nwz-nc1-1 ) )

     xx = [ sut ( ic ), sut ( ic ), sut ( ic ), sut ( ic ) - dxt,            $
            sut ( ic ), sut ( ic ) + dxt ]

     oplot, xx, yy

 endif

 eplt:

 if ( mode eq 3 ) then begin

     nstep = 4

     n4 = nstep * indgen ( ( np - 1 ) / nstep )
     np4 = n_elements ( n4 )

     dxf = ( xf ( n4 ( 1:np4-1 ) ) - xf ( n4 ( 0:np4-2 ) ) )

     wz = where ( abs ( dxf ) gt 3.675 )

     if ( wz ( 0 ) eq -1 ) then goto, pend

     wz4 = nstep * wz ( 0 ) + indgen ( nstep * n_elements ( wz ) )

     nslope = 1

     nwz = n_elements ( wz4 )

     dwz = wz4 ( 1:nwz-1 ) - wz4 ( 0:nwz-2 )

     wmx = where ( dwz gt 1.5 )

     nslope = n_elements ( wmx )

     if ( wmx ( 0 ) ne -1 ) then nslope = nslope + 1

     nc0 = 0

     for j = 0, nslope-1 do begin

         if ( j lt nslope-1 ) then nc1 = wmx ( j )
         if ( j eq nslope-1 ) then nc1 = n_elements ( wz4 ) - 1
         if ( nslope eq 1 ) then nc1 = n_elements ( wz4 ) - 1

         ic = fix ( total ( wz4 (nc0:nc1 ) ) / float ( nc1-nc0+1 ) )

         if ( ( ic le 1 ) or ( ic ge np-2 ) ) then goto, otrng

         xx = [ sut ( ic ) - dxt, sut ( ic ), sut ( ic ) + dxt ]

         yy = [ 3.50 * tick_sz, 3.50 * tick_sz,  0.0 ]

         if ( xf ( ic - 2 ) lt xf ( ic + 2 ) ) then                              $
              yy = [ 0.0, 3.50 * tick_sz, 3.50 * tick_sz ]

         oplot, xx, yy

         nc0 = nc1 + 1

 otrng:

         if ( nslope eq 1 ) then goto, pend

     endfor

 endif

pend:

 sut = sut0
 xf = xf0

 end

