;+
; Project     :	CLUSTER - RAPID
;
; Name        :	get_rapid_aux
;
; Purpose     :	Gets ephemeris or attitude data.
;
; Explanation : Ephemeris and attitude data is available in daily CDF files.
;
; Use         : < ephem = get_rapid_aux ( sc, time, /QUIET, /EPHEM ) >
;
; Inputs      : sc  : STRING character giving sc
;               time       : time in CDS format.
;
; Opt. Inputs : None.
;
; Outputs     : ephem          : structure giving ephemeris details.
;                                If none found then 0 returned.
;
; Opt. Outputs:	None.
;
; Keywords    : QUIET : If set suppresses printout.
;
; Written     :	Version 0.0, Martin Carter, RAL, 09/05/02
;
; Modified    : Version 0.1, 27/02/03
;                 Combined get_rapid_ephem and get_rapid_at into one routine.
;               Version 0.2, 09/10/03
;                 Used ies get dir.
;
; Version     :	Version 0.2, 09/10/03
;-
;**********************************************************

FUNCTION get_rapid_aux, sc, time, QUIET=quiet, EPHEM=ephem, AT=at

  ; convert time to external time

  ext_time = anytim2utc ( time, /EXTERNAL )

  ; find attitude AUX cdf file name : CL_SP_AUX_20010114_V01.cdf

  files = STRING( 'CL_SP_AUX_',ext_time.year, ext_time.month, ext_time.day, '_V*.cdf', FORMAT='(A,I4.4,I2.2,I2.2,A)' )

  ; look in

  files = concat_dir ( ies_get_dir('AUX_CDF',/RAPID), files)

  files = FINDFILE ( files, COUNT=count )

  ; if no files return

  IF count EQ 0 THEN RETURN, 0

  ; if more than one file then select last version

  IF count GT 1 THEN BEGIN

    list = SORT(files)

    files = files[list[count-1]]

  ENDIF

  ; read file

  RETURN, read_cdf_aux(sc, FILES=files[0], EPHEM=ephem, AT=at)

END


