;+
; Project     :	POLAR - CEPPAD
;
; Name        :	get_sc_at
;
; Purpose     :	Gets attitude data for POLAR or CLUSTER sc.
;
; Explanation : Gets attitude data for day defined by midpoint of time range specified
;               by header.
;
; Use         : < at = get_sc_at ( header, /QUIET ) >
;
; Inputs      : header       : STRUCTURE containing IF header info.
;
; Opt. Inputs : None.
;
; Outputs     : at          : structure giving attitude details.
;                                If none found then 0 returned.
;                                 .sut : time in decimal hours of day
;
; Opt. Outputs:	None.
;
; Keywords    : QUIET  : If set suppresses printout.
;
; Modified    :	Version 0.1, 29/07/02
;                 Corrected bug -- tried to use structure name to differentiate
;                 between CEPPAD and RAPID but POLAR IF files do not have POLAR
;                 in structure name.
;               Version 0.2, 27/02/03
;                 Switched to get_rapid_aux.
;
; Version     :	Version 0.2, 27/02/03
;-
;**********************************************************

FUNCTION get_sc_at, header, QUIET=quiet

  ; decide whether POLAR or CLUSTER

  IF STRPOS(header.datatype,'POLAR') EQ 0 THEN BEGIN

    RETURN, get_at ( (header.tstart+header.tstop)/2.0, QUIET=quiet)

  ENDIF ELSE IF STRPOS(header.datatype,'RAPID') EQ 0 THEN BEGIN

    RETURN, get_rapid_aux(STRMID(header.datatype,6,1),(header.tstart+header.tstop)/2.0, QUIET=quiet, /AT)

  ENDIF ELSE BEGIN

    RETURN, 0

  ENDELSE

END


