; Function to extract information from the CDF file
;
; If the file cannot be found then the function will return a value of -1 and the CNT
; finds specified tag and returns data for tag
; returns zero if tag not found

FUNCTION get_tag, str, tag_name, COUNT=count

  count = 0
 
  tags = TAG_NAMES(str)

  tag = WHERE(tags EQ tag_name, tcount)

  IF tcount EQ 0 THEN BEGIN

    MESSAGE, 'TAG NOT FOUND : '+tag_name, /INFORMATIONAL

    RETURN, 0

  ENDIF

  count = N_ELEMENTS(str.(tag[0]))

  RETURN, str.(tag[0])

END
