; Function to extract information from the daily AUX file
;
; If the file cannot be found then the function will return a value of -1 and the CNT
; keyword will be set to 0.
; On success the function returns a structure with the following
; specification and the CNT keyword is set to the number of records
;
;  sc  : STRING spacecraft '1','2','3','4'
;  day : STRING day 'yymmdd'
;
; Modified 25/02/02 from read cdf pse.pro
; Modified 13/05/02 from read cdf pgp.pro
; Modified 30/01/03 corrected bug so that structure returned properly
; Modified 04/02/03 converted ra and dec to radians
; Modified 09/10/03 Used ies get dir.


FUNCTION read_cdf_aux, sc, CNT=nrec, FILES=files, AT=at, EPHEM=ephem

  nrec = 0

  IF KEYWORD_SET(at) THEN BEGIN

    structure_name = 'CLUSTER_'+sc+'_AT_STRUCT_V1'

    IF NOT EXECUTE ( 'dummy_structure={' + structure_name + ',' + $
            'time:0.0d0,'+ $
            'gse_ra:0.0d0,' + $
            'gse_dec:0.0d0}' ) THEN RETURN, 0

    CASE sc OF
      '1' : list = [2,18,19]
      '2' : list = [2,20,21]
      '3' : list = [2,22,23]
      '4' : list = [2,24,25]
      ELSE : MESSAGE, 'IMPLEMENTATION ERROR'
    ENDCASE

  ENDIF ELSE BEGIN

    structure_name = 'CLUSTER_'+sc+'_EPHEM_STRUCT_V1'

    IF NOT EXECUTE ( 'dummy_structure={' + structure_name + ',' + $
            'time:0.0d0,'+ $
            'gse_xyz:FLTARR(3)}') THEN RETURN, 0

    CASE sc OF
      '1' : list = [2,6,10]
      '2' : list = [2,6,11]
      '3' : list = [2,6,12]
      '4' : list = [2,6,13]
      ELSE : MESSAGE, 'IMPLEMENTATION ERROR'
    ENDCASE

  ENDELSE

  IF NOT KEYWORD_SET(files) THEN $
    files = ies_pickfile(TITLE='Select AUX Files',/MULTIPLE_FILES,FILTER=['CL_SP_AUX_*.cdf'],PATH=ies_get_dir('AUX_CDF',/RAPID))

  IF NOT KEYWORD_SET(files) THEN RETURN, 0

  FOR f = 0, N_ELEMENTS(files)-1 DO BEGIN

    rcs_text, 'Reading '+files[f]

    str = read_cdf_zvars(files[f], LIST=list)

    IF KEYWORD_SET(str) THEN BEGIN

      times = str.(0)

      count = N_ELEMENTS(times)

      struct = REPLICATE(dummy_structure,count)

      struct.time = times

      IF KEYWORD_SET(at) THEN BEGIN

        ; set up ra and dec
        ; convert from degrees to radians

        struct.gse_dec = str.(1)/180.0*!PI

        struct.gse_ra  = str.(2)/180.0*!PI

      ENDIF ELSE BEGIN

        struct.gse_xyz = str.(1) + str.(2)

      ENDELSE

      IF NOT KEYWORD_SET(structure) THEN structure = struct ELSE structure = [structure,struct]

    ENDIF

  ENDFOR

  nrec = N_ELEMENTS(structure)

  IF KEYWORD_SET(structure) THEN RETURN, structure ELSE RETURN, 0

END
