; Function to extract information from the CDF file
;
; If the file cannot be found then the function will return a value of -1 and the CNT
; keyword will be set to 0.
; On success the function returns a structure with the following
; specification and the CNT keyword is set to the number of records

; Modified 30/01/03 added RCS_FGM_CDF_DIRECTORY environment variable
; Modified 09/10/03 Used rcs get dir.

FUNCTION read_cdf_fgm, sc, CNT=nrec, FILES=files

  nrec = 0

  sc = STRTRIM(STRING(sc),2)

  structure_name = 'FGM_GSE_STRUCT_SC'+sc+'_V0'

  IF NOT EXECUTE ( 'dummy_structure={' + structure_name + ',' + $
            'time:0.0d0,'+ $
            "mf:FLTARR(3)}" ) THEN RETURN, 0

  IF NOT KEYWORD_SET(files) THEN $
    files = ies_pickfile(TITLE='Select FGM Files',PATH=ies_get_dir('PGP_FGM',/RAPID),/MULTIPLE_FILES,FILTER=['C'+sc+'*'])

  IF NOT KEYWORD_SET(files) THEN RETURN, 0

  FOR f = 0, N_ELEMENTS(files)-1 DO BEGIN

    rcs_text, 'Reading '+files[f]

    str = read_cdf_zvars(files[f], LIST=[2,5])

    IF KEYWORD_SET(str) THEN BEGIN

      times = get_tag(str,'EPOCH__C'+sc+'_PP_FGM',COUNT=count)

      IF count GT 0 THEN BEGIN

        struct = REPLICATE(dummy_structure,count)

        struct.time = times

        struct.mf = get_tag(str,'B_XYZ_GSE__C'+sc+'_PP_FGM')

        IF NOT KEYWORD_SET(structure) THEN structure = struct ELSE structure = [structure,struct]

      ENDIF

    ENDIF

  ENDFOR

  nrec = N_ELEMENTS(structure)

  IF KEYWORD_SET(structure) THEN RETURN, structure ELSE RETURN, 0

END
