;read_cdf_pa.pro
; Function to extract ephemeris information from the CDF orbit
; file supplied on the raw data or KP CD-ROMs.
;
; Arguments: y,		year (YYYY)
;	     m,		month (MM)
;	     d,		day (DD)
; Keywords:  CNT	Returns the number of records found
;            FILE	Specifies the location of the orbit file
;			otherwise the program will try to find an
;		        appropriate file.
;
; If the file cannot be found or does not cover the requested 
; day then the function will return a value of -1 and the CNT
; keyword will be set to 0.
; On success the function returns a structure with the following
; specification and the CNT keyword is set to the number of records
; 
; 	date 		YYYY-MM-DD
;	nrec		Number of records
;	sc		Spacecraft Name (PO for Polar)
;	time(nrec)	Decimal UT hours
;	gse_yaw		
;	gse_pitch
;	gse_roll
;
;							CHP 11/96
;  Modified 19/2/97, MKC
;    Removed DEF type check and returned type via KEYWORD.
;  Modified 21/8/97, MKC
;    Handled case where epoch etc have only 1 element.
;       27/01/98 BEING MODIFIED TO COLLECT PA DATA....


FUNCTION read_cdf_pa,file, CNT=nrec, TYPE=type
	nrec = 0				; Clear number of records 
	; *** Open the CDF file ***
	IF ( N_ELEMENTS(file) NE 1) THEN   $
		file = STRING(y-1900,m,d,FORMAT="(I2.2,I2.2,I2.2,'01.cdf')")
	file1 = FINDFILE(file, COUNT=n)		; Check file path
	IF ( n NE 1 ) THEN RETURN, -1		; Invalid file specification
	id   = CDF_OPEN(file);

	; *** Get file information *** 
	cdf = CDF_INQUIRE(id)

;	 *** Make sure we have the right orbit file *** 
;	CDF_ATTGET, id, "Logical_file_id", 0, lfid
;	lfid = STR_SEP(lfid,"_")
;        type = lfid(2)
;	IF ( N_ELEMENTS(lfid) NE 5 OR lfid(0) NE "PO" OR $
;		lfid(1) NE "OR" OR lfid(3) NE date ) THEN BEGIN
;	   	CDF_CLOSE, id
;		PRINT, "ERROR - Bad orbit file selected"	
;   		RETURN,-1
;	ENDIF 
	; *** Get the data that we're interested in ***
	nrec = cdf.maxrec+1
	CDF_VARGET,id,"Epoch", REC_COUNT=nrec, COUNT=[1], epoch
	CDF_VARGET,id,"GSE_YAW", REC_COUNT=nrec, YAW
	CDF_VARGET,id,"GSE_PITCH", REC_COUNT=nrec,pitch
	CDF_VARGET,id,"GSE_ROLL", REC_COUNT=nrec, roll
	CDF_CLOSE, id

	; *** For scalers get rid of the unused dimension *** 
	epoch = REFORM([epoch])
;	mlt   = REFORM([mlt])
;	mlat  = REFORM([mlat])
;	lshell= REFORM([lshell])
	; *** Calculate a geocentris distance ***
;	r = REFORM(SQRT( pos(0,*)^2 + pos(1,*)^2 + pos(2,*)^2))

	; *** Convert Epoch to decimal hours on day ***
	ut = FLTARR(nrec)
	FOR i=0,nrec-1 DO BEGIN
		CDF_EPOCH, epoch(i), year, month, day, hour, min, sec, milli, /break
		ut(i) = hour + min/60.0 + sec/3600.0 + milli/3.6e6
	ENDFOR

;
	RETURN, { date:STRING(year,month,day,FORMAT="(I4.4,'-',I2.2,'-',I2.2)" ), $
		  n: nrec,  time: ut, gse_pitch: pitch(0,*), gse_yaw:yaw(0,*), gse_roll:roll(0,*)} 
end


;a=read_cdf_pa('pa.cdf')



; then use a.gse_yaw     etc
