; Function to extract information from the CDF file
;
; If the file cannot be found then the function will return a value of -1 and the CNT
; keyword will be set to 0.
; On success the function returns a structure with the following
; specification and the CNT keyword is set to the number of records
;
; Modified 25/02/02 from read cdf pse.pro
; Modified 30/01/03 added RCS_PGP_CDF_DIRECTORY environment variable
; Modified 09/10/03 Used ies get dir.

FUNCTION read_cdf_pgp, CNT=nrec, FILES=files

  nrec = 0

  structure_name = 'PGP_STRUCT_V1'

  IF NOT EXECUTE ( 'dummy_structure={' + structure_name + ',' + $
            'time:0.0d0,'+ $
            'xyz:FLTARR(3,4)}' ) THEN RETURN, 0

  IF NOT KEYWORD_SET(files) THEN files = ies_pickfile(TITLE='Select PGP Files',PATH=ies_get_dir('PGP_CDF',/RAPID),/MULTIPLE_FILES)

  IF NOT KEYWORD_SET(files) THEN RETURN, 0

  FOR f = 0, N_ELEMENTS(files)-1 DO BEGIN

    PRINT, 'Processing '+files[f]

    str = read_cdf_zvars(files[f], LIST=[2,4,8,9,10,11])

    IF KEYWORD_SET(str) THEN BEGIN

      times = get_tag(str,'EPOCH__CL_JP_PGP',COUNT=count)

      IF count GT 0 THEN BEGIN

        struct = REPLICATE(dummy_structure,count)

        struct.time = times

        ref = get_tag(str,'SC_R_XYZ_GSE__CL_JP_PGP',COUNT=count)

        struct.xyz[*,0] = ref + get_tag(str,'SC_DR1_XYZ_GSE__CL_JP_PGP',COUNT=count)

        struct.xyz[*,1] = ref + get_tag(str,'SC_DR2_XYZ_GSE__CL_JP_PGP',COUNT=count)

        struct.xyz[*,2] = ref + get_tag(str,'SC_DR3_XYZ_GSE__CL_JP_PGP',COUNT=count)

        struct.xyz[*,3] = ref + get_tag(str,'SC_DR4_XYZ_GSE__CL_JP_PGP',COUNT=count)

        IF NOT KEYWORD_SET(structure) THEN structure = struct ELSE structure = [structure,struct]

      ENDIF

    ENDIF

  ENDFOR

  nrec = N_ELEMENTS(structure)

  IF KEYWORD_SET(structure) THEN RETURN, structure ELSE RETURN, 0

END
