; Function to extract information from the CDF file
;
; If the file cannot be found then the function will return a value of 0
; On success the function returns a structure containing variables
;
;  Modified 22/01/02 from read_cdf_mfe.pro
;
;  24/10/03 : Changed the way the routine dals with PAD values.
;             Previously set PAD VALUE to zero, however this erquires write access to CDF file.
;             Now check if any PAD values and issue warning.

FUNCTION read_cdf_vars, file, LIST=list, QUERY=query

        struct = 0

	; *** Open the CDF file ***

	file1 = FINDFILE(file, COUNT=n)		; Check file path
	IF ( n NE 1 ) THEN RETURN, 0		; Invalid file specification
	id   = CDF_OPEN( file );

	; *** Get file information ***
	cdf = CDF_INQUIRE(id)
;print,'inquire'
;help,cdf,/str
;print,'cdf.dim=',cdf.dim

	; *** Get VAR names ***

        IF NOT KEYWORD_SET(list) THEN list = INDGEN(cdf.nvars)

        IF KEYWORD_SET(query) THEN struct = STRARR(N_ELEMENTS(list))

        FOR z = 0, N_ELEMENTS(list)-1 DO BEGIN

          str = CDF_VARINQ(id,list[z])
;print,'varinq'
;help,str,/str
          IF KEYWORD_SET(query) THEN BEGIN

            struct[z] = str.name

          ENDIF ELSE BEGIN

            CDF_CONTROL, id, VARIABLE=str.name, GET_VAR_INFO=var
;print,'control'
;help,var,/str

            IF var.maxrec GE 0 THEN BEGIN

              IF str.dimvar[0] THEN $
                CDF_VARGET, id, str.name, REC_COUNT=var.maxrec+1, val $
              ELSE $
                CDF_VARGET, id, str.name, REC_COUNT=var.maxrec+1, COUNT=1, val

              ; check for PAD values

              pad_list = WHERE(val EQ var.padvalue, pad_count)

              IF pad_count GT 0 THEN rcs_message, 'WARNING, PAD values encountered in '+file, /INFORMATIONAL

              ; do check for string and convert

              IF str.datatype EQ 'CDF_CHAR' THEN BEGIN

                ; expect string length (ie 1st dimension) to be given by numelem

                IF str.numelem NE (SIZE(val))[1] THEN PRINT, 'IMPLEMENTATION ERROR -- array sizes wrong'

                val = STRING(val)

              ENDIF

              val = REFORM([val])

              IF STRPOS(str.name,'Epoch') EQ 0 THEN BEGIN

                ; *** Convert Epoch to decimal hours on day ***

 	        FOR i = 0, N_ELEMENTS(val)-1 DO BEGIN

                  CDF_EPOCH, val[i], year, month, day, hour, min, sec, milli, /break

                  val[i] = utc2tai(anytim2utc(STRING(year,month,day,FORMAT="(I4.4,'-',I2.2,'-',I2.2)" ))) + $
                         hour*3600.0 + min*60.0 + sec + milli/1000.

	        ENDFOR

              ENDIF

              IF NOT KEYWORD_SET(struct) THEN BEGIN

                command = 'struct={' + STRCOMPRESS(str.name) + ':val}'

                res = EXECUTE ( command)

              ENDIF ELSE struct = add_tag(struct, val, STRCOMPRESS(str.name) )

            ENDIF

          ENDELSE

        ENDFOR

	CDF_CLOSE, id

	RETURN, struct

END
