;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_APPEND
;
; Purpose     :	Reads data file and appends to output file.
;
; Explanation :
;
; Use         : < rcs_make >
;
; Inputs      : None.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Calls       : None.
;
; Common      : None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    : GSEOS.
;
; Prev. Hist. :	None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 8/1/00
;
; Modified    :	None.
;
; Version     :	Version 0.0, 19/1/00
;-
;**********************************************************

PRO rcs_append

  ; set up ids structure

  ids = {base:0L, text:0L, in:{FILE, type:'DDS', file:0L, bytes:0L, time:0L}, outfile:0L, block:0L, start:0L}

  ; set base ID of widget

  ids.base = WIDGET_BASE(TITLE='DATA APPEND --RAPID COMMISSIONING SOFTWARE', /COL)

  ; set up widget font

  dummy = rcs_machine(/FONT)

  ; make row group for buttons

  first_row  = WIDGET_BASE ( ids.base, /ROW)

  ; set up logo

  logo   = ies_logo()
  dims   = SIZE(logo)
  logoid = WIDGET_DRAW ( first_row, XSIZE=dims(1), YSIZE=dims(2), UVALUE='LOGO', RETAIN=2, /BUTTON_EVENTS)

  ; make column group

  col = WIDGET_BASE ( first_row, /COL)

  ; make row group

  row1 = WIDGET_BASE ( col, /ROW)

  ; set up pull down menu

  items = [  '1\MENU',       $
             '0\START',      $
             '0\OPEN',       $
             '0\RESET',      $
             '0\STOP',       $
             '2\QUIT'         ]

  dummy = CW_PDMENU ( row1, items, UVALUE='MENU', /RETURN_NAME)

  dummy = WIDGET_LABEL(row1, VALUE='TIMER')

  timerid = WIDGET_TEXT(row1, XSIZE=20, YSIZE=1, VALUE='1.0', /EDITABLE, EVENT_PRO='rcs_append_timer')

  row1b = WIDGET_BASE(row1, /ROW, /NONEXCLUSIVE)

  ids.block = WIDGET_BUTTON(row1b, VALUE='INPUT BLOCKED')

  rcs_sensitive, ids.block, 0

  ; set uvalue to the value of the button

  ids.start = WIDGET_BUTTON(row1b, VALUE='GOING', UVALUE='0')

  rcs_sensitive, ids.start, 0

  ; next row

  row2 = WIDGET_BASE(col, /ROW)

  ; create widgets for input data

  dummy = WIDGET_LABEL(row2, VALUE='BYTES READ')

  ids.in[0].bytes = WIDGET_TEXT(row2, XSIZE=9, YSIZE=1, VALUE='')

  ; next row

  row3 = WIDGET_BASE(col, /ROW)

  ; create widgets for input data
  ; NB uses VALUE to store file names and UVALUE to store current unit no.

  dummy = WIDGET_LABEL(row3, VALUE='INFILE')

  ids.in[0].file = WIDGET_TEXT(row3, XSIZE=50, YSIZE=2, VALUE='', UVALUE=0)

  ; next row

  row4 = WIDGET_BASE(col, /ROW)

  ; create widgets for output data
  ; NB uses VALUE to store file names and UVALUE to store current unit no.

  dummy = WIDGET_LABEL(row4, VALUE='OUTFILE')

  ids.outfile = WIDGET_TEXT(row4, XSIZE=50, YSIZE=1, VALUE='', UVALUE=0)

  ; create widget for text output

  ids.text = WIDGET_TEXT(ids.base, XSIZE=80, YSIZE=10, /SCROLL, /WRAP, UVALUE=0)

  ; realize the widget

  WIDGET_CONTROL, ids.base, /REALIZE

  ; set base uvalue to widget IDs

  WIDGET_CONTROL, ids.base, SET_UVALUE=ids

  ; set blocked button off

  WIDGET_CONTROL, ids.block, SET_BUTTON=0

  ; set start button off

  WIDGET_CONTROL, ids.start, SET_BUTTON=0

  ; set up logo

  WIDGET_CONTROL, logoid, GET_VALUE=win

  WSET, win

  TV, logo

  ; start processing events

  XMANAGER, 'rcs_append', ids.base, /NO_BLOCK

  ; set timer going

  WIDGET_CONTROL, timerid, TIMER=1.0

END
