;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_APPEND_EVENT
;
; Purpose     :	Extracts data from NM input data stream.
;
; Explanation : Extracts data from NM input data stream.
;
; Use         : < RCS_MAKE_EVENT, event >
;
; Inputs      : None.
;
; Opt. Inputs : None.
;
; Outputs     :
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Calls       :
;
; Common      : rcs_make_block, rcs_make_event_local
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    : EDB.
;
; Prev. Hist. :	Adapted from analyze.
;
; Written     :	Version 0.0, Martin Carter, RAL, 8/1/00
;
; Modified    :	None.
;
; Version     :	Version 0.0, 8/1/00
;-
;**********************************************************

PRO rcs_append_event, event

  ; get widget IDs
  ; using widgets to store values rather than COMMON blocks to allow multiple instances

  WIDGET_CONTROL, event.top, GET_UVALUE=ids

  WIDGET_CONTROL, event.id, GET_UVALUE = uvalue

  CASE uvalue OF

   'MENU' : CASE event.value OF

        'START' : BEGIN

               ; set started flag

               WIDGET_CONTROL, ids.start, SET_BUTTON=1

               WIDGET_CONTROL, ids.start, SET_UVALUE='1'

             END

         'OPEN' : BEGIN

                    ; select files

                    rcs_add_files, ids, 0

                    rcs_outfile_manager, ids

                  END

         'STOP' : BEGIN
                    WIDGET_CONTROL, ids.start, SET_BUTTON=0
                    WIDGET_CONTROL, ids.start, SET_UVALUE='0'
                  END

         'RESET' : BEGIN

               ; reset text window

               rcs_text, ids.text, 'RESET', /RESET

               ; reset data COMMON blocks

               dummy = rcs_get_append( ids, /RESET)

               WIDGET_CONTROL, ids.block, SET_BUTTON=0

               WIDGET_CONTROL, ids.start, SET_BUTTON=0
               WIDGET_CONTROL, ids.start, SET_UVALUE='0'

             END

         'QUIT' : BEGIN
                    dummy = rcs_get_append( ids, /RESET)
                    WIDGET_CONTROL, event.top, /DESTROY
                  END

      ENDCASE

   'LOGO' : rcs_text, ids.text, 'LOGO pressed'

  ENDCASE

END
