;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_APPEND_TIMER
;
; Purpose     :	Extracts data from NM input data stream.
;
; Explanation : Extracts data from NM input data stream.
;
; Use         : < RCS_MAKE_EVENT, event >
;
; Inputs      : None.
;
; Opt. Inputs : None.
;
; Outputs     :
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Calls       :
;
; Common      : rcs_make_block, rcs_make_event_local
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    : EDB.
;
; Prev. Hist. :	Adapted from analyze.
;
; Written     :	Version 0.0, Martin Carter, RAL, 8/1/00
;
; Modified    :	None.
;
; Version     :	Version 0.0, 8/1/00
;-
;**********************************************************

PRO rcs_append_timer, event

  ; get widget IDs
  ; using widgets to store values rather than COMMON blocks to allow multiple instances

  WIDGET_CONTROL, event.top, GET_UVALUE=ids

  ; ignore TIMER event if not started : left over after stopped

  WIDGET_CONTROL, ids.start, GET_UVALUE=started

  IF started[0] NE '0' THEN BEGIN

    ; read more data
    ; if not completed OK then indicate file blocked

    IF rcs_get_append(ids) THEN $
      WIDGET_CONTROL, ids.block, SET_BUTTON=0 $
    ELSE $
      WIDGET_CONTROL, ids.block, SET_BUTTON=1

  ENDIF

  ; get timer

  WIDGET_CONTROL, event.id, GET_VALUE = value

  ; keep going

  WIDGET_CONTROL, event.id, TIMER=FLOAT(value[0])

END
