;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_GET_APPEND
;
; Purpose     :	Unpacks RAPID GSEOS or DDS data.
;
; Explanation : Reads a number of data blocks from a set of files.
;               If end of files reached then prompts for new file(s).
;               Extracts data to COMMON blocks.
;               Should be called with reset first time used.
;               NB GSEOS stamp is associated with ID.
;               Potentially could have more than one ID associated with the
;               same header.
;
; Use         : < result =  >
;
; Inputs      : None.
;
; Opt. Inputs : None.
;
; Outputs     : 0 : EOF FOUND.
;               1 : GOT DATA OK.
;
; Opt. Outputs: None.
;
; Keywords    : RESET   : FLAG indicating reset.
;
; Written     :	Version 0.0, Martin Carter, RAL, 8/1/00
;
; Modified    :	None.
;
; Version     :	Version 0.0, 8/1/00
;-
;**********************************************************

FUNCTION rcs_get_append, ids, RESET=reset

  ; set up io error response

  ON_IOERROR, io_error

  ; first time initializations
  ; NB cannot rely on COMMON block being uninitialized

  IF KEYWORD_SET(reset) THEN BEGIN

    ; reset files

    rcs_reset_files, ids

    rcs_outfile_manager, ids, /RESET

    RETURN, 0

  ENDIF

  ; set up structure  to store info about current state

  info = {INFO, unit:0L, file:'', nfiles:0, bytes:0L, time:0.0D0}

  ; get current file info

  WIDGET_CONTROL, ids.in[0].file, GET_UVALUE=unit

  info[0].unit = unit

  WIDGET_CONTROL, ids.in[0].file, GET_VALUE=files

  info[0].file = files[0]
  IF files[0] EQ '' THEN info[0].nfiles = 0 ELSE info[0].nfiles = N_ELEMENTS(files)

  ; get current output file info

  WIDGET_CONTROL, ids.outfile, GET_UVALUE=out_unit

  ; check if opened

  IF out_unit EQ 0 THEN RETURN, 0

  ; check if file open yet
  ; file may be part read and wish to continue or not yet opened
  ; dont want to call rcs_next_file if opened

  IF unit EQ 0 THEN BEGIN

    ; open file

    rcs_next_file, ids, info, 0

  ENDIF

  ; check if any files defined

  IF info.nfiles EQ 0 THEN RETURN, 0

  ; get bytes read

  WIDGET_CONTROL, ids.in[0].bytes, GET_VALUE=bytes_read

  bytes_read = LONG(bytes_read[0])

  ; set up array to hold packet

;  packet = BYTARR(1024)
  packet = BYTARR(675)

  ; read packet

  READU, info[0].unit, packet

  ; write packet

  WRITEU, out_unit, packet

  ; increment bytes read

  bytes_read = bytes_read + N_ELEMENTS(packet)

  WIDGET_CONTROL, ids.in[0].bytes, SET_VALUE=STRTRIM(STRING(bytes_read),2)

  RETURN, 1

  io_error : RETURN, 0

END
