;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_OUTFILE_MANAGER
;
; Purpose     :	Handles selection and opening of output data files.
;
; Explanation : Reads multiple file names into list.
;               Files span a limitted time period. This routine
;               handles selection of multiple files and returns a structure array
;               containing unit number and fiel names. Reads and checks the file
;               header if GSEOS file.
;               Assumes multiple files put into time order by file name.
;               Modes :
;                 RESET : Resets common block. Returns 0.
;                 ADD FILES : Adds file names to current list of files.
;                             Returns no of files in list. Not including currently open file.
;                 Else opens next file in list and returns structure containing :
;                         unit     : INT giving logical unit number
;                         file     : STRING giving file name
;                       If no more files returns 0,
;
; Use         : < >
;
; Inputs      : ids : STRUCTURE containign widget info and file type.
;
; Opt. Inputs : None.
;
; Outputs     : result : INT no. of files left in list.
;                        STRUCT details of next file.
;
; Opt. Outputs: None.
;
; Keywords    : RESET : FLAG indicating reset.
;               ADDFILES : FLAG indicating select more files.
;
; Written     :	Version 0.0, Martin Carter, RAL, 8/1/00
;
; Modified    :	None.
;
; Version     :	Version 0.0, 8/1/00
;-
;**********************************************************

PRO rcs_outfile_manager, ids, RESET=reset

  ON_IOERROR, error

  ; get unit

  WIDGET_CONTROL, ids.outfile, GET_UVALUE=unit

  ; get file name

  WIDGET_CONTROL, ids.outfile, GET_VALUE=file

  file = file[0]

  ; close previous open file
  ; NB 0 is not a valid unit

  IF KEYWORD_SET(unit) THEN BEGIN

    ; close file

    FREE_LUN, unit

    unit = 0

    IF file EQ '' THEN rcs_message, /IMPLEMENTATION

    file = ''

    WIDGET_CONTROL, ids.outfile, SET_VALUE=file

    WIDGET_CONTROL, ids.outfile, SET_UVALUE=unit

  ENDIF

  ; check keywords

  IF KEYWORD_SET(reset) THEN RETURN

  ; get new file name

  file = ies_pickfile ( COUNT=count, TITLE='Select OUTPUT file(s) or CANCEL' )

  ; deal with CANCEL

  IF count NE 1 THEN RETURN

  ; set file list

  WIDGET_CONTROL, ids.outfile, SET_VALUE=file

  ; open  file

  rcs_text, ids.text, 'OPENING OUTPUT FILE : '+file

  OPENW, unit, file, /GET_LUN

  ; set unit

  WIDGET_CONTROL, ids.outfile, SET_UVALUE=unit

  ; return

  RETURN

  ; error

  error : rcs_message, !ERR_STRING

END

