;+
; Project     :	CLUSTER - RAPID
;
; Name        :	RCS_DO_ESPCT
;
; Purpose     :	Calculates average over detectors for S/C.
;
; Explanation :	Omits detectors wich show anomalous pedestal contamination.
;               Adjusts counts back up to full detectors.
;
; Use         : < rcs_do_espct, sc, array
;
; Inputs      : sc           : STRING character giving spacecraft ID
;               array        : FLTARR(nsectors,ndetectors,nbands,npoints) counts
;
; Opt. Inputs : None.
;
; Outputs     : array        : FLTARR(nsectors,ndetectors,newbands,npoints) counts
;
; Opt. Outputs:	None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 08/04/01
;
; Modified    : Version 0.1, 17/12/03
;                 Removed luts and times from argument list since not used at present.
;                 Changed name from rcs espct to rcs do espct.
;
; Version     :	Version 0.1, 17/12/03
;-
;**********************************************************

PRO rcs_do_espct, sc, array

  CASE sc OF

    '1' : array = TOTAL(array,2)

    '2' : array = TOTAL(array,2)

    '3' : array = TOTAL(array[*,[3,4,5,6,7,8],*,*],2)*9./6.

    '4' : array = TOTAL(array[*,[0,1,2,3,4,5,7,8],*,*],2)*9./8.

    ELSE : rcs_message,/IMPLEMENTATION

  ENDCASE

END
