;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_EXTRACT_BMHIST
;
; Purpose     :	Extracts histogram data from BM EDB and constructs IF data
;
; Use         : < rcs_extract_bmhist, use, edb, time, sc, vs, flag, lut_no >
;
; Inputs      : use        : STRUCTURE containing flags indicating which IF data
;                            sets to make.
;               edb        : BYTARR EDB packet
;               time       : DOUBLE TAI time of EDB
;               sc         : STRING giving S/C
;               vs         : STRING IF version 'sss_v_a_b'
;               flag       : BYTE flag bits
;               lut_no     : INT strip no.
;
; Opt. Inputs : None.
;
; Outputs     : None
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 17/9/00
;
; Modified    :	Version 0.1, 13/12/00
;                 Added NM keyword to rcs_resample_hist.
;               Version 0.2, 22/04/01
;                 Changed name of COMMON block.
;                 Added erdifind qualifier.
;               Version 0.3, 18/07/01
;                 Added CDROM version number.
;
; Version     :	Version 0.3, 18/07/01
;-
;**********************************************************

PRO rcs_extract_bmhist, use, edb, time, sc, vs, flag, lut_no

  ; global common block

  COMMON rcs_ehist_block, header, data

  COMMON rcs_hk_qualifier_block, current_lut_no, current_erdifind

  IF NOT KEYWORD_SET(use.ehist) THEN RETURN

  ; get subc

  no = 2

  subc = edb['003'X] MOD no

  CASE subc OF

    0 : BEGIN

          ; EVEN BM1/BM3

          ehist = rcs_three(REFORM(edb['479'X:'479'X+768-1],3,256))

          rcs_add_data, rcs_get_scname(sc)+'_IES_EHIST', sc, vs, 'EHIST', 'EHIST', 1, $
                         time, header, data, ehist, current_lut_no, flag, 4.0

          ; set lut
          ; NB detector = datum.lut / 4
          ;    lut = datum.lut MOD 4

          data[header.npoints-1].lut = data[header.npoints-1].lut +(lut_no>0)*4

          ; add to e3dd

          IF KEYWORD_SET(use.e3dd) THEN BEGIN

            e3dd = LONARR(9,8)

            ; only add to single strip

            e3dd[(lut_no>0),*] = rcs_resample_hist(sc, time, (lut_no>0), current_lut_no, data[header.npoints-1].data[0,0,*],/NM)

            IF lut_no EQ -1 THEN $
              rcs_add_e3dd, sc, vs, time, e3dd, flag, lut_no $
            ELSE $
              rcs_add_e3dd, sc, vs, time, e3dd, flag, current_lut_no

          ENDIF

        END

    1 :

  ENDCASE

END
