;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_EXTRACT_NMHIST
;
; Purpose     :	Extracts histogram data from NM EDB and constructs IF data
;
; Use         : < rcs_extract_nmhist, use, edb, time, sc, vs, flag, lut_no >
;
; Inputs      : use        : STRUCTURE containing flags indicating which IF data
;                            sets to make.
;               edb        : BYTARR EDB packet
;               time       : DOUBLE TAI time of EDB
;               sc         : STRING giving S/C
;               vs         : STRING IF version 'sss_v_a_b'
;               flag       : BYTE flag bits
;               lut_no     : INT strip no.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 17/9/00
;
; Modified    :	Version 0.1, 13/12/00
;                 Added NM keyword to rcs_resample_hist.
;               Version 0.2, 22/04/01
;                 Changed name of COMMON block.
;                 Added erdifind qualifier.
;               Version 0.3, 18/07/01
;                 Added CDROM version number.
;
; Version     :	Version 0.3, 18/07/01
;-
;**********************************************************

PRO rcs_extract_nmhist, use, edb, time, sc, vs, flag, lut_no

  ; global common block

  COMMON rcs_ehist_block, header, data

  COMMON rcs_hk_qualifier_block, current_lut_no, current_erdifind

  IF NOT KEYWORD_SET(use.ehist) THEN RETURN

  ; get subc

  no = 2

  subc = edb['003'X] MOD no

  CASE subc OF

    0 : BEGIN

          ; EVEN NM/BM2

          ehist = rcs_decompress(edb['151'X:'151'X+167-1])

          rcs_add_ehist, sc, vs, time, ehist, lut_no, flag, current_lut_no, edb['003'X]

        END

    1 : BEGIN

          ; ODD NM/BM2

          ehist = rcs_decompress(edb['151'X:'151'X+88-1])

          ; NB byte 167 missing

          rcs_add_ehist, sc, vs, time, ehist, lut_no, flag, current_lut_no, edb['003'X]

          ; add to e3dd

          IF KEYWORD_SET(use.e3dd) THEN BEGIN

            e3dd = LONARR(9,8)

            ; only add to single strip

            e3dd[lut_no>0,*] = rcs_resample_hist(sc, time, lut_no>0, current_lut_no, data[header.npoints-1].data[0,0,*], /NM)

            IF lut_no EQ -1 THEN $
              rcs_add_e3dd, sc, vs, time, e3dd, flag, lut_no $
            ELSE $
              rcs_add_e3dd, sc, vs, time, e3dd, flag, current_lut_no

          ENDIF

        END

  ENDCASE

END
