;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_ADD_CLEANBM2
;
; Purpose     :	Adds IES data to CLEANBM2 IF data set.
;
; Explanation : Adds IES data to CLEANBM2 IF data set.
;
; Use         : < rcs_add_cleanbm2, sc, vs, time, clean, flag, lut_no, output_chans  >
;
; Inputs      : sc          : STRING containing spacecraft ID
;               vs          : STRING IF version 'sss_v_a_b'
;               time        : DOUBLE TAI time of start of EDB
;               clean       : FLTARR[nsectors,ndetectors,nenergies] clean counts
;               mvals       : BYTARR[] containing m data
;               flag        : BYTE flag bits
;               lut_no      : INT LUT used : 0-3.
;               output_chans: INTARR(2,newbands,ndetectors,nluts) new energy channel positions in bins for each detector and LUT
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 15/05/00
;
; Modified    : Version 0.1, 18/07/01
;                 Added CDROM version number.
;               Version 0.2, 27/02/02
;                 Added MVALS.
;               Version 0.3, 25/11/02
;                 Corrected bug where header.clean and output_chans not set up introduced in 0.2.
;               Version 0.4, 29/09/03
;                 Added SC to title.
;
; Version     :	Version 0.4, 29/09/03
;-
;**********************************************************

PRO rcs_add_cleanbm2, sc, vs, time, clean, mvals, flag, lut_no, output_chans

  ; global common block

  COMMON rcs_cleanbm2_block, header, data

  ; get no. of sectors in use
  ; this can not be dynamically changed without a reset of the common block

  no_of_sectors = (SIZE(clean))[1]

  ; add to header and data
  ; cancel subc flag since not subcommutated

  ; NB must do header check before header set up

  IF KEYWORD_SET(header) THEN BEGIN

    rcs_add_data, rcs_get_scname(sc)+'_IES_CLEANBM2', sc, vs, 'CLEANBM2', rcs_get_scname(sc)+' E-3DDBM CLEAN2', $
      no_of_sectors, time, header, data, clean, lut_no, flag AND 'DF'X, 4.0, MVALS=mvals

  ENDIF ELSE BEGIN

    rcs_add_data, rcs_get_scname(sc)+'_IES_CLEANBM2', sc, vs, 'CLEANBM2', rcs_get_scname(sc)+' E-3DDBM CLEAN2', $
      no_of_sectors, time, header, data, clean, lut_no, flag AND 'DF'X, 4.0, MVALS=mvals


    header.ch_positions = output_chans

    header.clean = 1

  ENDELSE

END
