;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_ADD_E3DD
;
; Purpose     :	Adds IES data to E3DD IF data set.
;
; Explanation : Adds IES data to E3DD IF data set.
;
; Use         : < rcs_add_e3dd, sc, vs, time, e3dd, flag, lut_no  >
;
; Inputs      : sc          : STRING character giving spacecraft ID
;               vs          : STRING IF version 'sss_v_a_b'
;               time        : DOUBLE TAI time of start of EDB
;               e3dd        : FLTARR (ndetectors, nenergies )  e3dd counts
;               flag        : BYTE flag bits
;               lut_no      : INT LUT used : 0-3.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : OFFSET : LONG offset in data.data
;
; Written     :	Version 0.0, 17/9/00
;
; Modified    : Version 0.1, 18/07/01
;                 Added CDROM version number.
;               Version 0.2, 08/07/02
;                 Added keyword OFFSET.
;               Version 0.3, 29/09/03
;                 Added SC to title.
;
; Version     :	Version 0.3, 29/09/03
;-
;**********************************************************

PRO rcs_add_e3dd, sc, vs, time, e3dd, flag, lut_no, OFFSET=offset

  ; global common block

  COMMON rcs_e3ddnm_block, header, data

  ; add to header and data
  ; cancel subc flag since not subcommutated

  rcs_add_data, rcs_get_scname(sc)+'_IES_E3DD', sc, vs, 'E3DD', rcs_get_scname(sc)+' NM E-3DD', $
    1, time, header, data, e3dd, lut_no, flag AND 'DF'X, 4.0, OFFSET=offset

END
