;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_ADD_E3DDBM
;
; Purpose     :	Adds BM IES E3DD data to E3DDBM IF data set.
;
; Explanation : Adds BM IES E3DD data to E3DDBM IF data set.
;
; Use         : < rcs_add_e3ddbm, sc, vs, time, e3dd, flag, lut_no  >
;
; Inputs      : sc          : STRING character giving spacecraft ID
;               vs          : STRING IF version 'sss_v_a_b'
;               time        : DOUBLE TAI time of start of EDB
;               e3dd        : FLTARR ( nsectors, ndetectors, nenergies )  e3dd counts
;               flag        : BYTE flag bits
;               lut_no      : INT LUT used : 0-3.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 17/9/00
;
; Modified    : Version 0.1, 18/07/01
;                 Added CDROM version number.
;               Version 0.2, 29/09/03
;                 Added SC to title.
;
; Version     :	Version 0.2, 29/09/03
;-
;**********************************************************

PRO rcs_add_e3ddbm, sc, vs, time, e3dd, flag, lut_no

  ; global common block

  COMMON rcs_e3ddbm_block, header, data

  ; get no. of sectors in use
  ; this can not be dynamically changed without a reset of the common block

  no_of_sectors = (SIZE(e3dd))[1]

  ; add to header and data
  ; cancel subc flag since not subcommutated

  rcs_add_data, rcs_get_scname(sc)+'_IES_E3DDBM_'+rcs_strtrim(no_of_sectors), sc, vs, 'E3DDBM', rcs_get_scname(sc)+' BM E-3DD', $
     no_of_sectors, time, header, data, e3dd, lut_no, flag AND 'DF'X, 4.0

END
