;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_ADD_EHIST
;
; Purpose     :	Adds NM HIST data to IF data set.
;
; Explanation : EHIST data covers 2 packets. In NM the first part of the histogram appears in even packet, the last part
;               in odd packet.
;
; Use         : < rcs_add_ehist, sc, vs, time, ehist, strip, flag, lut_no, subc  >
;
; Inputs      : sc          : STRING character giving spacecraft ID
;               vs          : STRING IF version 'sss_v_a_b'
;               time        : DOUBLE TAI time of start of EDB
;               ehist       : FLTARR ( nenergies )  histogram counts
;               strip       : INT 0:8 strip no, -1 = invalid
;               flag        : BYTE flag bits
;               lut_no      : INT LUT used : 0-3.
;               subc        : INT subcommutation index.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 17/9/00
;
; Modified    : Version 0.1, 18/07/01
;                 Added CDROM version number.
;               Version 0.2, 29/09/03
;                 Added SC to title.
;
; Version     :	Version 0.2, 29/09/03
;-
;**********************************************************

PRO rcs_add_ehist, sc, vs, time, ehist, strip, flag, lut_no, subc

  ; global common block

  COMMON rcs_ehist_block, header, data

  ; get subc

  no = 2

  subc = subc MOD no

  tflag = flag

  ; create new samples with zeroes
  ; if new set of data or missing data packets

  IF rcs_subc( header, data, subc, no, tflag) THEN BEGIN

    ; create new data sample
    ; add to header and data

    rcs_add_data, rcs_get_scname(sc)+'_IES_EHIST', sc, vs, 'EHIST', rcs_get_scname(sc)+' EHIST', 1, $
                  time, header, data, 0.0, lut_no, tflag, 8.0

    ; set lut
    ; NB detector = datum.lut / 4
    ;    lut = datum.lut MOD 4

    data[header.npoints-1].lut = data[header.npoints-1].lut+(strip>0)*4

  ENDIF

  ; insert data into array

  CASE subc OF

    0 : data[header.npoints-1].data = ehist

    1 : data[header.npoints-1].data[168:*] = ehist

  ENDCASE

END
