;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_ADD_EHK
;
; Purpose     :	Adds HK IES data to EHK IF data set.
;
; Explanation : Adds HK IES data to EHK IF data set.
;
; Use         : < rcs_add_ehk, sc, vs, time, ehk, flag, lut_no, subc  >
;
; Inputs      : sc          : STRING character giving spacecraft ID
;               vs          : STRING IF version 'sss_v_a_b'
;               time        : DOUBLE TAI time of start of EDB
;               ehk         : FLTARR hk counts
;               flag        : BYTE flag bits
;               lut_no      : INT LUT used : 0-3.
;               subc        : INT subcommutation index.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 17/9/00
;
; Modified    : Version 0.1, 18/07/01
;                 Added CDROM version number.
;               Version 0.2, 29/09/03
;                 Added SC to title.
;
; Version     :	Version 0.2, 29/09/03
;-
;**********************************************************

PRO rcs_add_ehk, sc, vs, time, ehk, flag, lut_no, subc

  ; global common block

  COMMON rcs_ehk_block, header, data

  no = 4

  subc = subc MOD no

  tflag = flag

  ; create new samples with zeroes
  ; if new set of data or missing data packets

  IF rcs_subc( header, data, subc, no, tflag) THEN BEGIN

    ; create new data sample

    rcs_add_data, rcs_get_scname(sc)+'_IES_EHK', sc, vs, 'EHK', rcs_get_scname(sc)+' E-HK', 1, time, header, data, 0.0, lut_no, tflag, 4.0

  ENDIF

  ; insert data into array

  data[header.npoints-1].data[0,*,subc] = ehk

END
