;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_ADD_EPAD
;
; Purpose     :	Adds IES EPAD data to EPAD IF data set.
;
; Explanation : Adds IES EPAD data to EPAD IF data set.
;
; Use         : < rcs_add_epad, sc, vs, time, epad, mvals, flag, lut_no  >
;
; Inputs      : sc          : STRING character giving spacecraft ID
;               vs          : STRING IF version 'sss_v_a_b'
;               time        : DOUBLE TAI time of start of EDB
;               epad        : FLTARR ( nsectors, ndetectors, nenergies )  e3dd counts
;               mvals       : BYTARR giving M values info
;               flag        : BYTE flag bits
;               lut_no      : INT LUT used : 0-3.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 17/9/00
;
; Modified    :	Version 0.1, 29/09/03
;                 Added SC to title.
;
; Version     :	Version 0.1, 29/09/03
;-
;**********************************************************

PRO rcs_add_epad, sc, vs, time, epad, mvals, flag, lut_no

  ; global common block

  COMMON rcs_epad_block, header, data

  ; get no. of sectors in use
  ; this can not be dynamically changed without a reset of the common block

  no_of_sectors = (SIZE(epad))[1]

  ; add to header and data
  ; cancel subc flag since not subcommutated

  rcs_add_data, rcs_get_scname(sc)+'_IES_EPAD_'+rcs_strtrim(no_of_sectors), sc, vs, 'EPAD', rcs_get_scname(sc)+' E-PAD', $
                no_of_sectors, time, header, data, epad, lut_no, flag AND 'DF'X, 4.0, MVALS=mvals

END
