;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_ADD_EPAD2
;
; Purpose     :	Adds IES EPAD data to EPAD2 IF data set.
;
; Explanation : Adds IES EPAD data to EPAD2 IF data set.
;               EPAD2 has sectors expanded along time line.
;
; Use         : < rcs_add_epad2, sc, vs, time, epad, mvals, flag, lut_no  >
;
; Inputs      : sc          : STRING character giving spacecraft ID
;               vs          : STRING IF version 'sss_v_a_b'
;               time        : DOUBLE TAI time of start of EDB
;               epad        : FLTARR ( nsectors, ndetectors, nenergies )  e3dd counts
;               mvals       : BYTARR giving M values info
;               flag        : BYTE flag bits
;               lut_no      : INT LUT used : 0-3.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 08/02/02
;
; Modified    :	Version 0.1, 29/09/03
;                 Added SC to title.
;
; Version     :	Version 0.1, 29/09/03
;-
;**********************************************************

PRO rcs_add_epad2, sc, vs, time, epad, mvals, flag, lut_no

  ; global common block

  COMMON rcs_epad2_block, header, data

  ; add to header and data
  ; cancel subc flag since not subcommutated

  rcs_add_data, rcs_get_scname(sc)+'_IES_EPAD2', sc, vs, 'EPAD2', rcs_get_scname(sc)+' E-PAD', $
                1, time, header, data, epad, lut_no, flag AND 'DF'X, 0.25, MVALS=mvals

  ; luts = [ 2 boundaries, 3 energies, 9 detectors, 4 LUTs * nchanges]
  ; however header.ndetectors = 3
  ; MVALS contains the extra information necessary to get the right LUT

END
