;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_ADD_ESPCT
;
; Purpose     :	Adds IES data to ESPCT IF data set.
;
; Explanation : Adds IES data to ESPCT IF data set.
;
; Use         : < rcs_add_espct, sc, vs, time, espct, flag, lut_no, output_chans  >
;
; Inputs      : sc          : STRING containing spacecraft ID
;               vs          : STRING IF version 'sss_v_a_b'
;               time        : DOUBLE TAI time of start of EDB
;               espct       : FLTARR (nenergies ) counts
;               flag        : BYTE flag bits
;               lut_no      : INT LUT used : 0-3.
;               output_chans: INTARR(2,newbands,ndetectors,nluts) new energy channel positions in bins for each detector and LUT
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 9/2/01
;
; Modified    : Version 0.1, 18/07/01
;                 Added CDROM version number.
;               Version 0.2, 29/09/03
;                 Added SC to title.
;
; Version     :	Version 0.2, 29/09/03
;-
;**********************************************************

PRO rcs_add_espct, sc, vs, time, espct, flag, lut_no, output_chans

  ; global common block

  COMMON rcs_espct_block, header, data

  ; add to header and data
  ; cancel subc flag since not subcommutated

  IF KEYWORD_SET(header) THEN BEGIN

    rcs_add_data, rcs_get_scname(sc)+'_IES_ESPCT', sc, vs, 'ESPCT', rcs_get_scname(sc)+' E-3DD ESPCT', 1, time, header, data, espct, lut_no, flag AND 'DF'X, 4.0

  ENDIF ELSE BEGIN

    rcs_add_data, rcs_get_scname(sc)+'_IES_ESPCT', sc, vs, 'ESPCT', rcs_get_scname(sc)+' E-3DD ESPCT', 1, time, header, data, espct, lut_no, flag AND 'DF'X, 4.0

    ; clean channels are the same for each detector

    header.ch_positions = output_chans[*,*,0,*]

    header.clean = 1

  ENDELSE

END
