;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_ADD_HK1
;
; Purpose     :	Adds some HK data to IF HK data set.
;
; Explanation : This IF data set contains relevant HK data that is not sub-commutated.
;               Currently :
;               'ERISTAHV','ERISTOHV','ERIDEFHV','ERDTRIGM','ERDIFIND','ERDIFCAL','ERDDEADT','ERDHKFCR'
;               'ERISTACB', 'ERISTOCB', 'ERIENYCB', ERDTMMOD
;               Calibrate HV.
;               Convert ERDTRIGM to 0-8.
;               Convert flags to 0-1.
;               Decompressed compressed counts combined with least significant byte.
;
; Use         : < rcs_add_hk1, sc, vs, time, hk, flag, lut_no >
;
; Inputs      : sc          : STRING character giving spacecraft ID
;               vs          : STRING IF version 'sss_v_a_b'
;               time        : DOUBLE TAI time of start of EDB
;               hk          : BYTARR hk data packet
;               flag        : BYTE flag bits
;               lut_no      : INT IES LUT no : 0-3.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 17/9/00
;
; Modified    :	Version 0.1, 25/05/01
;                 Added TMMOD, STA, STO, ENY rates.
;               Version 0.2, 18/07/01
;                 Added CDROM version number.
;               Version 0.3, 29/09/03
;                 Added SC to title.
;
; Version     :	Version 0.3, 29/09/03
;-
;**********************************************************

PRO rcs_add_hk1, sc, vs, time, hk, flag, lut_no

  ; global common block

  COMMON rcs_hk1_block, header, data

  ; extract ERISTAHV, ERISTOHV, ERIDEFHV

  eristahv = hk[11]

  eristohv = hk[12]

  eridefhv = hk[13]

  ; store HV's ERISTAHV, ERISTOHV, ERIDEFHV
  ; apply calibration data

  rcs_hv_cal, ERISTAHV=eristahv, ERISTOHV=eristohv, ERIDEFHV=eridefhv

  ; convert to kV

  eristahv = eristahv/1000.

  eristohv = eristohv/1000.

  eridefhv = eridefhv/1000.

  ; extract ERDTRIGM : IIMS trigger mode

  erdtrigm = hk[0]

  ; convert to 0-8

  erdtrigm = ISHFT(erdtrigm, -5)

  ; extract erdifind : IIMS serial/parallel mode

  erdifind = hk[1]

  ; convert to 0-1

  erdifind = (erdifind AND '40'X) NE 0

  ; extract erdifcal : IFFT flag

  erdifcal = hk[7]

  ; convert to 0-1

  erdifcal = (erdifcal AND '02'X) NE 0

  ; extract erddeadt : deadtime timeout flag

  erddeadt = hk[7]

  ; convert to 0-1

  erddeadt = (erddeadt AND '04'X) NE 0

  ; extract erdhkfcr : frame counter

  erdhkfcr = hk[0]

  ; convert to 0-31

  erdhkfcr = erdhkfcr AND '1F'X

  ; extract eristacp and eristalb

  eristacb = (rcs_decompress(hk[21]) AND 'FFFFFF00'XL) + hk[22]

  ; extract eristocp and eristolb

  eristocb = (rcs_decompress(hk[23]) AND 'FFFFFF00'XL) + hk[24]

  ; extract erienycp and erienylb

  erienycb = (rcs_decompress(hk[25]) AND 'FFFFFF00'XL) + hk[26]

  ; extract ERDTMMOD : IIMS telemetry mode

  erdtmmod = ISHFT((hk[1] AND '18'XB),-3)

  ; add to header and data

  IF NOT KEYWORD_SET(header) THEN BEGIN
    ptitle = ['ERISTAHV','ERISTOHV','ERIDEFHV','ERDTRIGM','ERDIFIND','ERDIFCAL','ERDDEADT','ERDHKFCR', $
              'ERISTACB','ERISTOCB', 'ERIENYCB','ERDTTMOD']
    ztitle = 'HV [kV]'
  ENDIF

  ; NB leave fc invalid flag
  ; add b version change

  rcs_add_data, rcs_get_scname(sc)+'_HK1', sc, vs, 'HK1', rcs_get_scname(sc)+' HK1', 1, time, header, data, $
    [eristahv,eristohv,eridefhv,erdtrigm,erdifind,erdifcal,erddeadt,erdhkfcr,eristacb,eristocb,erienycb,erdtmmod], $
    lut_no, flag, 8.0, PTITLE=ptitle, ZTITLE=ztitle, EXDATA = 'b'

END
