;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_ADD_HK32
;
; Purpose     : Adds modulo 32 subcommutated HK data to IF data set.
;
; Explanation : HK32 data set consists of :
;               'ERDTOERC','ERDFRPRT','EREFXLUT','ERDSPPOS'
;               Calibrate values.
;
; Use         : < rcs_add_hk32, sc, vs, time, hk, flag  >
;
; Inputs      : sc          : STRING character giving spacecraft ID
;               vs          : STRING IF version 'sss_v_a_b'
;               time        : DOUBLE TAI time of start of packet
;               hk          : BYTARR HK data packet
;               flag        : BYTE flag bits
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 17/9/00
;
; Modified    :	Version 0.1, 25/05/01
;                 Added sun sector and sun position.
;               Version 0.2, 18/07/01
;                 Added CDROM version number.
;               Version 0.3, 29/09/03
;                 Added SC to title.
;
; Version     :	Version 0.3, 29/09/03
;-
;**********************************************************

PRO rcs_add_hk32, sc, vs, time, hk, flag

  ; global common block

  COMMON rcs_hk32_block, header, data

  ; conditioned by ERDHKFCR

  no = 32

  subc = hk[0] MOD no

  tflag = flag

  ; create new samples with zeroes
  ; if new set of data or missing data packets

  IF rcs_subc( header, data, subc, no, tflag) THEN BEGIN

    ; create new data sample

    IF NOT KEYWORD_SET(header) THEN ptitle = ['ERDTOERC','ERDFRPRT','EREFXLUT','ERDSPPOS','ERDSPSEC']

    ; added b version change

    rcs_add_data, rcs_get_scname(sc)+'_HK32', sc, vs, 'HK32', rcs_get_scname(sc)+' HK32', 1, time, header, data, 0.0, 0, tflag, 128.0, PTITLE=ptitle, EXDATA = 'b'

  ENDIF

  ; insert data into array

  CASE subc OF

    25 : BEGIN

          ; ERDTOERC MSB

          data[header.npoints-1].data[0,0,0] = 256L*hk[39]

        END

    26 : BEGIN

          ; ERDTOERC LSB

          data[header.npoints-1].data[0,0,0] = data[header.npoints-1].data[0,0,0] + hk[39]

        END

    27 : BEGIN

          ; ERDFRPRT MSB

          data[header.npoints-1].data[0,1,0] = 256L*hk[39]

        END

    28 : BEGIN

          ; ERDFRPRT LSB

          data[header.npoints-1].data[0,1,0] = data[header.npoints-1].data[0,1 ,0] + hk[39]

        END

    29 : BEGIN

          ; EREFXLUT

          data[header.npoints-1].data[0,2,0] = (hk[39] AND '08'X) NE 0

        END

    30 : BEGIN

          ; ERDSPPOS

          data[header.npoints-1].data[0,3,0] = hk[39]

        END

    31 : BEGIN

          ; ERDSPSEC

          data[header.npoints-1].data[0,4,0] = hk[39] AND '0F'X

        END

    ELSE : RETURN

  ENDCASE

END
