;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_ADD_HK8
;
; Purpose     : Adds modulo 8 subcommutated HK data to IF data set.
;
; Explanation : HK8 data set consists of :
;               'ERDGNDRF','ERIP5VRF','ERIM5VRF','ERIP12RF','ERIM12RF','ERISAREF','ERISTREF','ERIHKTRF'
;               Calibrate values.
;
; Use         : < rcs_add_hk8, sc, vs, time, hk, flag  >
;
; Inputs      : sc          : STRING character giving spacecraft ID
;               vs          : STRING IF version 'sss_v_a_b'
;               time        : DOUBLE TAI time of start of packet
;               hk            HK data packet
;               flag        : BYTE flag bits
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 17/9/00
;
; Modified    : Version 0.1, 18/07/01
;                 Added CDROM version number.
;               Version 0.2, 29/09/03
;                 Added SC to title.
;
; Version     :	Version 0.2, 29/09/03
;-
;**********************************************************

PRO rcs_add_hk8, sc, vs, time, hk, flag

  ; global common block

  COMMON rcs_hk8_block, header, data

  ; conditioned by ERDHKFCR

  no = 8

  subc = hk[0] MOD no

  hk8 = hk[38]

  tflag = flag

  ; create new samples with zeroes
  ; if new set of data or missing data packets

  IF subc EQ 0 OR rcs_subc( header, data, subc, no, tflag) THEN BEGIN

    ; create new data sample

    IF NOT KEYWORD_SET(header) THEN ptitle = ['ERDGNDRF','ERIP5VRF','ERIM5VRF','ERIP12RF','ERIM12RF','ERISAREF','ERISTREF','ERIHKTRF']

    rcs_add_data, rcs_get_scname(sc)+'_HK8', sc, vs, 'HK8', rcs_get_scname(sc)+' HK8', 1, time, header, data, 0.0, 0, tflag, 8.0, PTITLE=ptitle

  ENDIF

  ; insert data into array

  CASE subc OF

    0 : BEGIN

          ; ERDGNDRF

          analog = (2.5 - hk8*5/256.)*2.

          data[header.npoints-1].data[0,0,0] = analog

        END

    1 : BEGIN

          ; ERIP5VRF

          analog = (2.5 - hk8*5/256.)*2.5724

          data[header.npoints-1].data[0,1,0] = analog

        END

    2 : BEGIN

          ; ERIM5VRF

          analog = (2.5 - hk8*5/256.)*2.5026

          data[header.npoints-1].data[0,2,0] = analog

        END

    3 : BEGIN

          ; ERIP12RF

          analog = (2.5 - hk8*5/256.)*6.552

          data[header.npoints-1].data[0,3,0] = analog

        END

    4 : BEGIN

          ; ERIM12RF

          analog = (2.5 - hk8*5/256.)*6.379

          data[header.npoints-1].data[0,4,0] = analog

        END

    5 : BEGIN

          ; ERISAREF

          analog = (2.5 - hk8*5/256.)*2.

          data[header.npoints-1].data[0,5,0] = analog

        END

    6 : BEGIN

          ; ERISTREF

          analog = (2.5 - hk8*5/256.)*40

          data[header.npoints-1].data[0,6,0] = analog

        END

    7 : BEGIN

          ; ERIHKTRF

          analog = (2.5 - hk8*5/256.)*40

          data[header.npoints-1].data[0,7,0] = analog

        END

    ELSE : RETURN

  ENDCASE

END
