;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_ADD_HSPCT
;
; Purpose     :	Adds IIMS HSPCT data to HSPCT IF data set.
;
; Explanation : Adds IIMS HSPCT data to HSPCT IF data set.
;
; Use         : < rcs_add_hspct, sc, vs, time, hspct, flag  >
;
; Inputs      : sc          : STRING character giving spacecraft ID
;               vs          : STRING IF version 'sss_v_a_b'
;               time        : DOUBLE TAI time of start of EDB
;               hspct       : FLTARR counts
;               flag        : FLAG flag bits
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 17/9/00
;
; Modified    : Version 0.1, 18/07/01
;                 Added CDROM version number.
;               Version 0.2, 29/09/03
;                 Added SC to title.
;
; Version     :	Version 0.2, 29/09/03
;-
;**********************************************************

PRO rcs_add_hspct, sc, vs, time, hspct, flag

  ; global common block

  COMMON rcs_hspct_block, header, data

  ; create new samples
  ; cancel LUT flag and subc invalid flag

  rcs_add_data, rcs_get_scname(sc)+'_IIMS_HSPCT', sc, vs, 'HSPCT', rcs_get_scname(sc)+' HSPCT', 1, time, header, data, hspct, 0, flag AND 'CF'X, 4.0

END
